/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.relation;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnComponentRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.MultiColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.relation.TokenRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.core.CqlIdentifiers;
import com.datastax.oss.driver.internal.querybuilder.DefaultRaw;
import com.datastax.oss.driver.internal.querybuilder.relation.CustomIndexRelation;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultColumnComponentRelationBuilder;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultColumnRelationBuilder;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultMultiColumnRelationBuilder;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultTokenRelationBuilder;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;

public interface OngoingWhereClause<SelfT extends OngoingWhereClause<SelfT>> {
    @NonNull
    @CheckReturnValue
    public SelfT where(@NonNull Relation var1);

    @NonNull
    @CheckReturnValue
    public SelfT where(@NonNull Iterable<Relation> var1);

    @NonNull
    @CheckReturnValue
    default public SelfT where(Relation ... additionalRelations) {
        return this.where(Arrays.asList(additionalRelations));
    }

    @NonNull
    default public ColumnRelationBuilder<SelfT> whereColumn(@NonNull CqlIdentifier id) {
        return new DefaultColumnRelationBuilder.Fluent(this, id);
    }

    @NonNull
    default public ColumnRelationBuilder<SelfT> whereColumn(@NonNull String name) {
        return this.whereColumn(CqlIdentifier.fromCql(name));
    }

    @NonNull
    default public ColumnComponentRelationBuilder<SelfT> whereMapValue(@NonNull CqlIdentifier columnId, @NonNull Term index) {
        return new DefaultColumnComponentRelationBuilder.Fluent(this, columnId, index);
    }

    @NonNull
    default public ColumnComponentRelationBuilder<SelfT> whereMapValue(@NonNull String columnName, @NonNull Term index) {
        return this.whereMapValue(CqlIdentifier.fromCql(columnName), index);
    }

    @NonNull
    default public TokenRelationBuilder<SelfT> whereTokenFromIds(@NonNull Iterable<CqlIdentifier> identifiers) {
        return new DefaultTokenRelationBuilder.Fluent(this, identifiers);
    }

    @NonNull
    default public TokenRelationBuilder<SelfT> whereToken(CqlIdentifier ... identifiers) {
        return this.whereTokenFromIds(Arrays.asList(identifiers));
    }

    @NonNull
    default public TokenRelationBuilder<SelfT> whereToken(@NonNull Iterable<String> names) {
        return this.whereTokenFromIds(CqlIdentifiers.wrap(names));
    }

    @NonNull
    default public TokenRelationBuilder<SelfT> whereToken(String ... names) {
        return this.whereToken(Arrays.asList(names));
    }

    @NonNull
    default public MultiColumnRelationBuilder<SelfT> whereColumnIds(@NonNull Iterable<CqlIdentifier> identifiers) {
        return new DefaultMultiColumnRelationBuilder.Fluent(this, identifiers);
    }

    @NonNull
    default public MultiColumnRelationBuilder<SelfT> whereColumns(CqlIdentifier ... identifiers) {
        return this.whereColumnIds(Arrays.asList(identifiers));
    }

    @NonNull
    default public MultiColumnRelationBuilder<SelfT> whereColumns(@NonNull Iterable<String> names) {
        return this.whereColumnIds(CqlIdentifiers.wrap(names));
    }

    @NonNull
    default public MultiColumnRelationBuilder<SelfT> whereColumns(String ... names) {
        return this.whereColumns(Arrays.asList(names));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT whereCustomIndex(@NonNull CqlIdentifier indexId, @NonNull Term expression) {
        return this.where((Relation)new CustomIndexRelation(indexId, expression));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT whereCustomIndex(@NonNull String indexName, @NonNull Term expression) {
        return this.whereCustomIndex(CqlIdentifier.fromCql(indexName), expression);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT whereRaw(@NonNull String raw) {
        return this.where((Relation)new DefaultRaw(raw));
    }
}

