/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.relation;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.CqlSnippet;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnComponentRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.MultiColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.TokenRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.core.CqlIdentifiers;
import com.datastax.oss.driver.internal.querybuilder.relation.CustomIndexRelation;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultColumnComponentRelationBuilder;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultColumnRelationBuilder;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultMultiColumnRelationBuilder;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultTokenRelationBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;

public interface Relation
extends CqlSnippet {
    @NonNull
    public static ColumnRelationBuilder<Relation> column(@NonNull CqlIdentifier id) {
        return new DefaultColumnRelationBuilder(id);
    }

    @NonNull
    public static ColumnRelationBuilder<Relation> column(@NonNull String name) {
        return Relation.column(CqlIdentifier.fromCql(name));
    }

    @NonNull
    public static ColumnComponentRelationBuilder<Relation> mapValue(@NonNull CqlIdentifier columnId, @NonNull Term index) {
        return new DefaultColumnComponentRelationBuilder(columnId, index);
    }

    @NonNull
    public static ColumnComponentRelationBuilder<Relation> mapValue(@NonNull String columnName, @NonNull Term index) {
        return Relation.mapValue(CqlIdentifier.fromCql(columnName), index);
    }

    @NonNull
    public static TokenRelationBuilder<Relation> tokenFromIds(@NonNull Iterable<CqlIdentifier> identifiers) {
        return new DefaultTokenRelationBuilder(identifiers);
    }

    @NonNull
    public static TokenRelationBuilder<Relation> token(CqlIdentifier ... identifiers) {
        return Relation.tokenFromIds(Arrays.asList(identifiers));
    }

    @NonNull
    public static TokenRelationBuilder<Relation> token(@NonNull Iterable<String> names) {
        return Relation.tokenFromIds(CqlIdentifiers.wrap(names));
    }

    @NonNull
    public static TokenRelationBuilder<Relation> token(String ... names) {
        return Relation.token(Arrays.asList(names));
    }

    @NonNull
    public static MultiColumnRelationBuilder<Relation> columnIds(@NonNull Iterable<CqlIdentifier> identifiers) {
        return new DefaultMultiColumnRelationBuilder(identifiers);
    }

    @NonNull
    public static MultiColumnRelationBuilder<Relation> columns(CqlIdentifier ... identifiers) {
        return Relation.columnIds(Arrays.asList(identifiers));
    }

    @NonNull
    public static MultiColumnRelationBuilder<Relation> columns(@NonNull Iterable<String> names) {
        return Relation.columnIds(CqlIdentifiers.wrap(names));
    }

    @NonNull
    public static MultiColumnRelationBuilder<Relation> columns(String ... names) {
        return Relation.columns(Arrays.asList(names));
    }

    @NonNull
    public static Relation customIndex(@NonNull CqlIdentifier indexId, @NonNull Term expression) {
        return new CustomIndexRelation(indexId, expression);
    }

    @NonNull
    public static Relation customIndex(@NonNull String indexName, @NonNull Term expression) {
        return Relation.customIndex(CqlIdentifier.fromCql(indexName), expression);
    }

    public boolean isIdempotent();
}

