/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.schema;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;

public interface KeyspaceReplicationOptions<TargetT> {
    @NonNull
    default public TargetT withSimpleStrategy(int replicationFactor) {
        ImmutableMap<String, Object> replication = ImmutableMap.builder().put("class", "SimpleStrategy").put("replication_factor", (String)((Object)Integer.valueOf(replicationFactor))).build();
        return this.withReplicationOptions(replication);
    }

    @NonNull
    default public TargetT withNetworkTopologyStrategy(@NonNull Map<String, Integer> replications) {
        ImmutableMap.Builder<String, String> replicationBuilder = ImmutableMap.builder().put("class", "NetworkTopologyStrategy");
        for (Map.Entry<String, Integer> replication : replications.entrySet()) {
            replicationBuilder.put(replication.getKey(), (String)((Object)replication.getValue()));
        }
        return this.withReplicationOptions(replicationBuilder.build());
    }

    @NonNull
    public TargetT withReplicationOptions(@NonNull Map<String, Object> var1);
}

