/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.metrics.DefaultMetricId;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.internal.core.metrics.MetricIdGenerator;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class TaggingMetricIdGenerator
implements MetricIdGenerator {
    private final String sessionName;
    private final String sessionPrefix;
    private final String nodePrefix;

    public TaggingMetricIdGenerator(DriverContext context) {
        this.sessionName = context.getSessionName();
        String prefix = Objects.requireNonNull(context.getConfig().getDefaultProfile().getString(DefaultDriverOption.METRICS_ID_GENERATOR_PREFIX, ""));
        this.sessionPrefix = prefix.isEmpty() ? "session." : prefix + ".session.";
        this.nodePrefix = prefix.isEmpty() ? "nodes." : prefix + ".nodes.";
    }

    @Override
    @NonNull
    public MetricId sessionMetricId(@NonNull SessionMetric metric) {
        return new DefaultMetricId(this.sessionPrefix + metric.getPath(), ImmutableMap.of("session", this.sessionName));
    }

    @Override
    @NonNull
    public MetricId nodeMetricId(@NonNull Node node, @NonNull NodeMetric metric) {
        return new DefaultMetricId(this.nodePrefix + metric.getPath(), ImmutableMap.of("session", this.sessionName, "node", node.getEndPoint().toString()));
    }
}

