/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ReplayingEventFilter<EventT> {
    private final Consumer<EventT> consumer;
    private final ReadWriteLock stateLock = new ReentrantReadWriteLock();
    @GuardedBy(value="stateLock")
    private State state;
    @GuardedBy(value="stateLock")
    private final List<EventT> recordedEvents;

    public ReplayingEventFilter(Consumer<EventT> consumer) {
        this.consumer = consumer;
        this.state = State.NEW;
        this.recordedEvents = new CopyOnWriteArrayList<EventT>();
    }

    public void start() {
        this.stateLock.writeLock().lock();
        try {
            this.state = State.STARTED;
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public void markReady() {
        this.stateLock.writeLock().lock();
        try {
            this.state = State.READY;
            for (EventT event : this.recordedEvents) {
                this.consumer.accept(event);
            }
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void accept(EventT event) {
        this.stateLock.readLock().lock();
        try {
            switch (this.state) {
                case NEW: {
                    return;
                }
                case STARTED: {
                    this.recordedEvents.add(event);
                    return;
                }
                case READY: {
                    this.consumer.accept(event);
                    return;
                }
            }
            return;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @VisibleForTesting
    public List<EventT> recordedEvents() {
        this.stateLock.readLock().lock();
        try {
            ImmutableList<EventT> immutableList = ImmutableList.copyOf(this.recordedEvents);
            return immutableList;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    private static enum State {
        NEW,
        STARTED,
        READY;

    }
}

