/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.relation;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.OngoingWhereClause;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.lhs.ColumnLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultRelation;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultColumnRelationBuilder
implements ColumnRelationBuilder<Relation> {
    private final CqlIdentifier columnId;

    public DefaultColumnRelationBuilder(@NonNull CqlIdentifier columnId) {
        Preconditions.checkNotNull(columnId);
        this.columnId = columnId;
    }

    @Override
    @NonNull
    public Relation build(@NonNull String operator, @Nullable Term rightOperand) {
        return new DefaultRelation(new ColumnLeftOperand(this.columnId), operator, rightOperand);
    }

    @Immutable
    public static class Fluent<StatementT extends OngoingWhereClause<StatementT>>
    implements ColumnRelationBuilder<StatementT> {
        private final OngoingWhereClause<StatementT> statement;
        private final ColumnRelationBuilder<Relation> delegate;

        public Fluent(@NonNull OngoingWhereClause<StatementT> statement, @NonNull CqlIdentifier columnId) {
            this.statement = statement;
            this.delegate = new DefaultColumnRelationBuilder(columnId);
        }

        @Override
        @NonNull
        public StatementT build(@NonNull String operator, @Nullable Term rightOperand) {
            return this.statement.where((Relation)this.delegate.build(operator, rightOperand));
        }
    }
}

