/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class CastSelector
implements Selector {
    private final Selector selector;
    private final DataType targetType;
    private final CqlIdentifier alias;

    public CastSelector(@NonNull Selector selector, @NonNull DataType targetType) {
        this(selector, targetType, null);
    }

    public CastSelector(@NonNull Selector selector, @NonNull DataType targetType, @Nullable CqlIdentifier alias) {
        Preconditions.checkNotNull(selector);
        Preconditions.checkNotNull(targetType);
        Preconditions.checkArgument(selector.getAlias() == null, "Inner selector can't be aliased");
        this.selector = selector;
        this.targetType = targetType;
        this.alias = alias;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append("CAST(");
        this.selector.appendTo(builder);
        builder.append(" AS ").append(this.targetType.asCql(false, true)).append(')');
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new CastSelector(this.selector, this.targetType, alias);
    }

    @NonNull
    public Selector getSelector() {
        return this.selector;
    }

    @NonNull
    public DataType getTargetType() {
        return this.targetType;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CastSelector) {
            CastSelector that = (CastSelector)other;
            return this.selector.equals(that.selector) && this.targetType.equals(that.targetType) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.targetType, this.alias);
    }
}

