/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class ElementSelector
implements Selector {
    private final Selector collection;
    private final Term index;
    private final CqlIdentifier alias;

    public ElementSelector(@NonNull Selector collection, @NonNull Term index) {
        this(collection, index, null);
    }

    public ElementSelector(@NonNull Selector collection, @NonNull Term index, @Nullable CqlIdentifier alias) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(index);
        this.collection = collection;
        this.index = index;
        this.alias = alias;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new ElementSelector(this.collection, this.index, alias);
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        this.collection.appendTo(builder);
        builder.append('[');
        this.index.appendTo(builder);
        builder.append(']');
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @NonNull
    public Selector getCollection() {
        return this.collection;
    }

    @NonNull
    public Term getIndex() {
        return this.index;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ElementSelector) {
            ElementSelector that = (ElementSelector)other;
            return this.collection.equals(that.collection) && this.index.equals(that.index) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.collection, this.index, this.alias);
    }
}

