/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class RangeSelector
implements Selector {
    private final Selector collection;
    private final Term left;
    private final Term right;
    private final CqlIdentifier alias;

    public RangeSelector(@NonNull Selector collection, @Nullable Term left, @Nullable Term right) {
        this(collection, left, right, null);
    }

    public RangeSelector(@NonNull Selector collection, @Nullable Term left, @Nullable Term right, @Nullable CqlIdentifier alias) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument(left != null || right != null, "At least one of the bounds must be specified");
        this.collection = collection;
        this.left = left;
        this.right = right;
        this.alias = alias;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new RangeSelector(this.collection, this.left, this.right, alias);
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        this.collection.appendTo(builder);
        builder.append('[');
        if (this.left != null) {
            this.left.appendTo(builder);
        }
        builder.append("..");
        if (this.right != null) {
            this.right.appendTo(builder);
        }
        builder.append(']');
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @NonNull
    public Selector getCollection() {
        return this.collection;
    }

    @Nullable
    public Term getLeft() {
        return this.left;
    }

    @Nullable
    public Term getRight() {
        return this.right;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RangeSelector) {
            RangeSelector that = (RangeSelector)other;
            return this.collection.equals(that.collection) && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.collection, this.left, this.right, this.alias);
    }
}

