/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class TypeHintSelector
implements Selector {
    private final Selector selector;
    private final DataType targetType;
    private final CqlIdentifier alias;

    public TypeHintSelector(@NonNull Selector selector, @NonNull DataType targetType) {
        this(selector, targetType, null);
    }

    public TypeHintSelector(@NonNull Selector selector, @NonNull DataType targetType, @Nullable CqlIdentifier alias) {
        Preconditions.checkNotNull(selector);
        Preconditions.checkNotNull(targetType);
        this.selector = selector;
        this.targetType = targetType;
        this.alias = alias;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new TypeHintSelector(this.selector, this.targetType, alias);
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append('(').append(this.targetType.asCql(false, true)).append(')');
        this.selector.appendTo(builder);
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @NonNull
    public Selector getSelector() {
        return this.selector;
    }

    @NonNull
    public DataType getTargetType() {
        return this.targetType;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TypeHintSelector) {
            TypeHintSelector that = (TypeHintSelector)other;
            return this.selector.equals(that.selector) && this.targetType.equals(that.targetType) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.targetType, this.alias);
    }
}

