/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.term;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class FunctionTerm
implements Term {
    private final CqlIdentifier keyspaceId;
    private final CqlIdentifier functionId;
    private final Iterable<Term> arguments;

    public FunctionTerm(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId, @NonNull Iterable<Term> arguments) {
        Preconditions.checkNotNull(functionId);
        Preconditions.checkNotNull(arguments);
        this.keyspaceId = keyspaceId;
        this.functionId = functionId;
        this.arguments = arguments;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        CqlHelper.qualify(this.keyspaceId, this.functionId, builder);
        builder.append('(');
        CqlHelper.append(this.arguments, builder, null, ",", null);
        builder.append(')');
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @Nullable
    public CqlIdentifier getKeyspaceId() {
        return this.keyspaceId;
    }

    @NonNull
    public CqlIdentifier getFunctionId() {
        return this.functionId;
    }

    @NonNull
    public Iterable<Term> getArguments() {
        return this.arguments;
    }
}

