/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cassandra.CassandraEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.utils.cassandra.CassandraUtils;

public class CassandraProducer
extends DefaultProducer {
    private PreparedStatement preparedStatement;

    public CassandraProducer(CassandraEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.isPrepareStatements() && this.getEndpoint().getCql() != null) {
            this.preparedStatement = this.getEndpoint().prepareStatement();
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.preparedStatement = null;
        super.doStop();
    }

    @Override
    public CassandraEndpoint getEndpoint() {
        return (CassandraEndpoint)super.getEndpoint();
    }

    public boolean isPrepareStatements() {
        return this.getEndpoint().isPrepareStatements();
    }

    private Object[] getCqlParams(Message message) {
        Object[] cqlParams;
        Object cqlParamsObj = message.getBody();
        Class<Object[]> objectArrayClazz = Object[].class;
        if (cqlParamsObj == null) {
            cqlParams = null;
        } else if (objectArrayClazz.isInstance(cqlParamsObj)) {
            cqlParams = (Object[])objectArrayClazz.cast(cqlParamsObj);
        } else if (cqlParamsObj instanceof Collection) {
            Collection cqlParamsColl = (Collection)cqlParamsObj;
            cqlParams = cqlParamsColl.toArray();
        } else {
            cqlParams = new Object[]{cqlParamsObj};
        }
        return cqlParams;
    }

    private ResultSet execute(Message message) {
        Object messageCql = message.getHeader("CamelCqlQuery");
        if (messageCql instanceof String && ((String)messageCql).isEmpty()) {
            messageCql = null;
        }
        Object[] cqlParams = this.getCqlParams(message);
        CqlSession session = this.getEndpoint().getSessionHolder().getSession();
        ResultSet resultSet = this.isPrepareStatements() ? this.executePreparedStatement(session, messageCql, cqlParams) : this.executeStatement(session, messageCql, cqlParams);
        return resultSet;
    }

    private ResultSet executePreparedStatement(CqlSession session, Object messageCql, Object[] cqlParams) {
        PreparedStatement lPreparedStatement;
        if (messageCql == null) {
            lPreparedStatement = this.preparedStatement;
        } else if (messageCql instanceof String) {
            lPreparedStatement = this.getEndpoint().prepareStatement((String)messageCql);
        } else if (messageCql instanceof SimpleStatement) {
            lPreparedStatement = this.getEndpoint().getSession().prepare((SimpleStatement)messageCql);
        } else {
            throw new IllegalArgumentException("Invalid CamelCqlQuery header");
        }
        ResultSet resultSet = CassandraUtils.isEmpty(cqlParams) ? session.execute(lPreparedStatement.bind(new Object[0])) : session.execute(lPreparedStatement.bind(cqlParams));
        return resultSet;
    }

    private ResultSet executeStatement(CqlSession session, Object messageCql, Object[] cqlParams) {
        ResultSet resultSet = null;
        String cql = null;
        SimpleStatement statement = null;
        if (messageCql == null) {
            cql = this.getEndpoint().getCql();
        } else if (messageCql instanceof String) {
            cql = (String)messageCql;
        } else if (messageCql instanceof SimpleStatement) {
            statement = (SimpleStatement)messageCql;
        } else {
            throw new IllegalArgumentException("Invalid CamelCqlQuery header");
        }
        resultSet = statement != null ? session.execute(statement) : (CassandraUtils.isEmpty(cqlParams) ? session.execute(cql) : session.execute(SimpleStatement.builder(cql).addPositionalValues(cqlParams).build()));
        return resultSet;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        exchange.getMessage().copyFrom(exchange.getIn());
        ResultSet resultSet = this.execute(exchange.getIn());
        this.getEndpoint().fillMessage(resultSet, exchange.getMessage());
    }
}

