/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import org.apache.camel.CamelContext;
import org.apache.camel.processor.idempotent.cassandra.CassandraIdempotentRepository;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class CassandraIdempotentRepositoryConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        CassandraIdempotentRepository target = (CassandraIdempotentRepository)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "pkcolumns": 
            case "pkColumns": {
                target.setPkColumns(CassandraIdempotentRepositoryConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "prefixpkvalues": 
            case "prefixPKValues": {
                target.setPrefixPKValues(CassandraIdempotentRepositoryConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "readconsistencylevel": 
            case "readConsistencyLevel": {
                target.setReadConsistencyLevel(CassandraIdempotentRepositoryConfigurer.property(camelContext, ConsistencyLevel.class, value));
                return true;
            }
            case "session": {
                target.setSession(CassandraIdempotentRepositoryConfigurer.property(camelContext, CqlSession.class, value));
                return true;
            }
            case "table": {
                target.setTable(CassandraIdempotentRepositoryConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "ttl": {
                target.setTtl(CassandraIdempotentRepositoryConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "writeconsistencylevel": 
            case "writeConsistencyLevel": {
                target.setWriteConsistencyLevel(CassandraIdempotentRepositoryConfigurer.property(camelContext, ConsistencyLevel.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "pkcolumns": 
            case "pkColumns": {
                return String.class;
            }
            case "prefixpkvalues": 
            case "prefixPKValues": {
                return String.class;
            }
            case "readconsistencylevel": 
            case "readConsistencyLevel": {
                return ConsistencyLevel.class;
            }
            case "session": {
                return CqlSession.class;
            }
            case "table": {
                return String.class;
            }
            case "ttl": {
                return Integer.class;
            }
            case "writeconsistencylevel": 
            case "writeConsistencyLevel": {
                return ConsistencyLevel.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        CassandraIdempotentRepository target = (CassandraIdempotentRepository)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "pkcolumns": 
            case "pkColumns": {
                return target.getPkColumns();
            }
            case "prefixpkvalues": 
            case "prefixPKValues": {
                return target.getPrefixPKValues();
            }
            case "readconsistencylevel": 
            case "readConsistencyLevel": {
                return target.getReadConsistencyLevel();
            }
            case "session": {
                return target.getSession();
            }
            case "table": {
                return target.getTable();
            }
            case "ttl": {
                return target.getTtl();
            }
            case "writeconsistencylevel": 
            case "writeConsistencyLevel": {
                return target.getWriteConsistencyLevel();
            }
        }
        return null;
    }
}

