/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.coap.CamelCoapResource;
import org.apache.camel.coap.CoAPComponent;
import org.apache.camel.coap.CoAPConstants;
import org.apache.camel.coap.CoAPConsumer;
import org.apache.camel.coap.CoAPHelper;
import org.apache.camel.coap.CoAPNotifier;
import org.apache.camel.coap.CoAPObserver;
import org.apache.camel.coap.CoAPProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.ClientAuthentication;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.tcp.netty.TcpClientConnector;
import org.eclipse.californium.elements.tcp.netty.TlsClientConnector;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.16.0", scheme="coap,coaps,coap+tcp,coaps+tcp", title="CoAP", syntax="coap:uri", category={Category.IOT}, headersClass=CoAPConstants.class)
public class CoAPEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    static final Logger LOGGER = LoggerFactory.getLogger(CoAPEndpoint.class);
    @UriPath
    private URI uri;
    @UriParam(label="consumer", enums="DELETE,GET,POST,PUT")
    private String coapMethodRestrict;
    @UriParam(label="security", secret=true)
    private PrivateKey privateKey;
    @UriParam(label="security")
    private PublicKey publicKey;
    @UriParam(label="security")
    private NewAdvancedCertificateVerifier advancedCertificateVerifier;
    @UriParam(label="security")
    private AdvancedPskStore advancedPskStore;
    @UriParam(label="security")
    private String cipherSuites;
    private transient String[] configuredCipherSuites;
    @UriParam(label="security")
    private CertificateAuthenticationMode clientAuthentication;
    @UriParam(label="security", enums="NONE,WANT,REQUIRE")
    private String alias;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="security", defaultValue="true")
    private boolean recommendedCipherSuitesOnly = true;
    @UriParam(label="consumer", defaultValue="false")
    private boolean observe;
    @UriParam(label="consumer", defaultValue="false")
    private boolean observable;
    @UriParam(label="producer", defaultValue="false")
    private boolean notify;
    private CoAPComponent component;

    public CoAPEndpoint(String uri, CoAPComponent component) {
        super(uri, component);
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException use) {
            this.uri = null;
        }
        this.component = component;
    }

    @Override
    public String getServiceUrl() {
        if (this.uri != null) {
            return this.uri.toString();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        if (this.uri != null) {
            return this.uri.getScheme();
        }
        return null;
    }

    public void setCoapMethodRestrict(String coapMethodRestrict) {
        this.coapMethodRestrict = coapMethodRestrict;
    }

    public String getCoapMethodRestrict() {
        return this.coapMethodRestrict;
    }

    @Override
    public Producer createProducer() throws Exception {
        if (this.isNotify()) {
            return new CoAPNotifier(this);
        }
        return new CoAPProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        DefaultConsumer consumer = this.isObserve() ? new CoAPObserver(this, processor) : new CoAPConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public void setUri(URI u) {
        this.uri = u;
    }

    public URI getUri() {
        return this.uri;
    }

    public CamelCoapResource getCamelCoapResource(String path) throws IOException, GeneralSecurityException {
        Resource current;
        Iterator<String> pathSegments = CoAPHelper.getPathSegmentsFromPath(path).iterator();
        if (!pathSegments.hasNext()) {
            return null;
        }
        for (current = this.getCoapServer().getRoot(); pathSegments.hasNext() && current != null; current = current.getChild(pathSegments.next())) {
        }
        return (CamelCoapResource)current;
    }

    public List<String> getPathSegmentsFromURI() {
        return CoAPHelper.getPathSegmentsFromPath(this.getUri().getPath());
    }

    public CoapServer getCoapServer() throws IOException, GeneralSecurityException {
        return this.component.getServer(this.getUri().getPort(), this);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isObserve() {
        return this.observe;
    }

    public void setObserve(boolean observe) {
        this.observe = observe;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public NewAdvancedCertificateVerifier getAdvancedCertificateVerifier() {
        return this.advancedCertificateVerifier;
    }

    public void setAdvancedCertificateVerifier(NewAdvancedCertificateVerifier advancedCertificateVerifier) {
        this.advancedCertificateVerifier = advancedCertificateVerifier;
    }

    public AdvancedPskStore getAdvancedPskStore() {
        return this.advancedPskStore;
    }

    public void setAdvancedPskStore(AdvancedPskStore advancedPskStore) {
        this.advancedPskStore = advancedPskStore;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public String getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String cipherSuites) {
        this.cipherSuites = cipherSuites;
        if (cipherSuites != null) {
            this.configuredCipherSuites = cipherSuites.split(",");
        }
    }

    private String[] getConfiguredCipherSuites() {
        if (this.configuredCipherSuites != null) {
            return this.configuredCipherSuites;
        }
        if (this.sslContextParameters != null && this.sslContextParameters.getCipherSuites() != null) {
            return this.sslContextParameters.getCipherSuites().getCipherSuite().toArray(new String[0]);
        }
        return null;
    }

    public CertificateAuthenticationMode getClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(CertificateAuthenticationMode clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    public boolean isRecommendedCipherSuitesOnly() {
        return this.recommendedCipherSuitesOnly;
    }

    public void setRecommendedCipherSuitesOnly(boolean recommendedCipherSuitesOnly) {
        this.recommendedCipherSuitesOnly = recommendedCipherSuitesOnly;
    }

    public boolean isClientAuthenticationRequired() {
        CertificateAuthenticationMode clientAuth = this.clientAuthentication;
        if (clientAuth == null && this.sslContextParameters != null && this.sslContextParameters.getServerParameters() != null) {
            clientAuth = CertificateAuthenticationMode.valueOf(this.sslContextParameters.getServerParameters().getClientAuthentication());
        }
        return clientAuth == CertificateAuthenticationMode.NEEDED;
    }

    public boolean isClientAuthenticationWanted() {
        CertificateAuthenticationMode clientAuth = this.clientAuthentication;
        if (clientAuth == null && this.sslContextParameters != null && this.sslContextParameters.getServerParameters() != null) {
            clientAuth = CertificateAuthenticationMode.valueOf(this.sslContextParameters.getServerParameters().getClientAuthentication());
        }
        return clientAuth != null && ClientAuthentication.valueOf(String.valueOf((Object)clientAuth)) == ClientAuthentication.WANT;
    }

    private X509Certificate[] getTrustedCerts() throws GeneralSecurityException, IOException {
        if (this.sslContextParameters != null && this.sslContextParameters.getTrustManagers() != null) {
            KeyStore trustStore = this.sslContextParameters.getTrustManagers().getKeyStore().createKeyStore();
            Enumeration<String> aliases = trustStore.aliases();
            ArrayList<X509Certificate> trustCerts = new ArrayList<X509Certificate>();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)trustStore.getCertificate(alias);
                if (cert == null) continue;
                trustCerts.add(cert);
            }
            return trustCerts.toArray(new X509Certificate[0]);
        }
        return new X509Certificate[0];
    }

    public static boolean enableDTLS(URI uri) {
        return "coaps".equals(uri.getScheme());
    }

    public static boolean enableTCP(URI uri) {
        return uri.getScheme().endsWith("+tcp");
    }

    public DTLSConnector createDTLSConnector(InetSocketAddress address, boolean client) throws IOException {
        Configuration cfg;
        try {
            cfg = Configuration.getStandard();
        }
        catch (Exception e) {
            cfg = new Configuration();
        }
        DtlsConnectorConfig.Builder builder = new DtlsConnectorConfig.Builder(cfg);
        if (client) {
            this.setupCreateDTLSConnectorClient(builder);
        } else {
            this.setupCreateDTLSConnectorServer(address, builder);
        }
        try {
            Certificate[] certs;
            if (this.sslContextParameters != null && this.sslContextParameters.getKeyManagers() != null) {
                this.configureIdentity(builder);
            } else if (this.privateKey != null) {
                builder.setCertificateIdentityProvider(new SingleCertificateProvider(this.privateKey, this.publicKey));
            }
            if (this.advancedPskStore != null) {
                builder.setAdvancedPskStore(this.advancedPskStore);
            }
            if ((certs = this.getTrustedCerts()).length > 0) {
                NewAdvancedCertificateVerifier trust = StaticNewAdvancedCertificateVerifier.builder().setTrustedCertificates(certs).build();
                builder.setAdvancedCertificateVerifier(trust);
            }
            if (this.advancedCertificateVerifier != null) {
                builder.set(DtlsConfig.DTLS_CERTIFICATE_TYPES, Arrays.asList(CertificateType.RAW_PUBLIC_KEY));
                builder.setAdvancedCertificateVerifier(this.advancedCertificateVerifier);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Error in configuring TLS", e);
        }
        if (this.getConfiguredCipherSuites() != null) {
            LOGGER.debug("There are configured cipher suites: {}", (Object[])this.getConfiguredCipherSuites());
            builder.set(DtlsConfig.DTLS_CIPHER_SUITES, CipherSuite.getTypesByNames(this.getConfiguredCipherSuites()));
        }
        return new DTLSConnector(builder.build());
    }

    private void configureIdentity(DtlsConnectorConfig.Builder builder) throws GeneralSecurityException, IOException {
        KeyManagersParameters keyManagers = this.sslContextParameters.getKeyManagers();
        KeyStore keyStore = keyManagers.getKeyStore().createKeyStore();
        String alias = this.getAlias();
        if (alias == null) {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String ksAlias = aliases.nextElement();
                if (!keyStore.isKeyEntry(ksAlias)) continue;
                alias = ksAlias;
                break;
            }
        }
        if (alias == null) {
            throw new IllegalStateException("The sslContextParameters keystore must contain a key entry");
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, keyManagers.getKeyPassword().toCharArray());
        builder.setCertificateIdentityProvider(new SingleCertificateProvider(privateKey, keyStore.getCertificateChain(alias), new CertificateType[0]));
    }

    private void setupCreateDTLSConnectorServer(InetSocketAddress address, DtlsConnectorConfig.Builder builder) {
        if (this.privateKey == null && this.sslContextParameters == null && this.advancedPskStore == null) {
            throw new IllegalStateException("Either a privateKey, sslContextParameters or advancedPskStore object must be configured for a TLS service");
        }
        if (this.privateKey != null && this.publicKey == null) {
            throw new IllegalStateException("A public key must be configured to use a Raw Public Key with TLS");
        }
        if ((this.isClientAuthenticationRequired() || this.isClientAuthenticationWanted()) && (this.sslContextParameters == null || this.sslContextParameters.getTrustManagers() == null) && this.publicKey == null) {
            throw new IllegalStateException("A truststore must be configured to support TLS client authentication");
        }
        builder.setAddress(address);
        if (this.isClientAuthenticationRequired()) {
            builder.set(DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, CertificateAuthenticationMode.NEEDED);
        } else if (this.isClientAuthenticationWanted()) {
            builder.set(DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, CertificateAuthenticationMode.WANTED);
        } else {
            builder.set(DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, CertificateAuthenticationMode.NONE);
        }
        builder.set(DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, this.isRecommendedCipherSuitesOnly());
    }

    private void setupCreateDTLSConnectorClient(DtlsConnectorConfig.Builder builder) {
        if (this.advancedCertificateVerifier == null && this.sslContextParameters == null && this.advancedPskStore == null) {
            throw new IllegalStateException("Either an advancedCertificateVerifier, sslContextParameters or advancedPskStore object must be configured for a TLS client");
        }
        builder.set(DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, this.isRecommendedCipherSuitesOnly());
        builder.set(DtlsConfig.DTLS_ROLE, DtlsConfig.DtlsRole.CLIENT_ONLY);
    }

    public CoapClient createCoapClient(URI uri) throws IOException, GeneralSecurityException {
        CoapClient client = new CoapClient(uri);
        if (CoAPEndpoint.enableDTLS(uri)) {
            DTLSConnector connector = this.createDTLSConnector(null, true);
            CoapEndpoint.Builder coapBuilder = new CoapEndpoint.Builder();
            coapBuilder.setConnector(connector);
            client.setEndpoint(coapBuilder.build());
        } else if (CoAPEndpoint.enableTCP(this.getUri())) {
            TcpClientConnector tcpConnector;
            if (this.getUri().getScheme().startsWith("coaps")) {
                SSLContextParameters params = this.getSslContextParameters();
                if (params == null) {
                    params = new SSLContextParameters();
                }
                SSLContext sslContext = params.createSSLContext(this.getCamelContext());
                tcpConnector = new TlsClientConnector(sslContext, Configuration.createStandardWithoutFile());
            } else {
                tcpConnector = new TcpClientConnector(Configuration.createStandardWithoutFile());
            }
            CoapEndpoint.Builder tcpBuilder = new CoapEndpoint.Builder();
            tcpBuilder.setConnector(tcpConnector);
            client.setEndpoint(tcpBuilder.build());
        }
        return client;
    }
}

