/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.util.LinkedList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.coap.CoAPConstants;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.MediaTypeRegistry;

public final class CoAPHelper {
    private CoAPHelper() {
    }

    public static String getDefaultMethod(Exchange exchange, CoapClient client) {
        String method = exchange.getIn().getHeader("CamelCoapMethod", String.class);
        if (method == null) {
            Object body = exchange.getIn().getBody();
            method = body == null || client.getURI().contains("?") ? "GET" : "POST";
        }
        return method;
    }

    public static String getDefaultMethodRestrict(String methodRestrict) {
        if (ObjectHelper.isNotEmpty(methodRestrict)) {
            return methodRestrict;
        }
        return CoAPConstants.METHOD_RESTRICT_ALL;
    }

    public static List<String> getPathSegmentsFromPath(String path) {
        LinkedList<String> segments = new LinkedList<String>();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (!path.isEmpty()) {
            int idx = path.indexOf(47);
            if (idx == -1) {
                segments.add(path);
                break;
            }
            segments.add(path.substring(0, idx));
            path = path.substring(idx + 1);
        }
        return segments;
    }

    public static void convertCoapResponseToMessage(CoapResponse coapResponse, Message message) {
        String mt = MediaTypeRegistry.toString(coapResponse.getOptions().getContentFormat());
        message.setHeader("Content-Type", mt);
        message.setHeader("CamelCoapResponseCode", coapResponse.getCode().toString());
        message.setBody(coapResponse.getPayload());
    }
}

