/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.coap.CoAPHelper;
import org.apache.camel.support.DefaultProducer;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.MediaTypeRegistry;

public class CoAPProducer
extends DefaultProducer {
    private final CoAPEndpoint endpoint;
    private volatile CoapClient client;

    public CoAPProducer(CoAPEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.initClient();
        String ct = exchange.getIn().getHeader("Content-Type", String.class);
        if (ct == null) {
            ct = "application/octet-stream";
        }
        String method = CoAPHelper.getDefaultMethod(exchange, this.client);
        int mediaType = MediaTypeRegistry.parse(ct);
        CoapResponse response = null;
        boolean pingResponse = false;
        switch (method) {
            case "GET": {
                response = this.client.get();
                break;
            }
            case "DELETE": {
                response = this.client.delete();
                break;
            }
            case "POST": {
                byte[] bodyPost = exchange.getIn().getBody(byte[].class);
                response = this.client.post(bodyPost, mediaType);
                break;
            }
            case "PUT": {
                byte[] bodyPut = exchange.getIn().getBody(byte[].class);
                response = this.client.put(bodyPut, mediaType);
                break;
            }
            case "PING": {
                pingResponse = this.client.ping();
                break;
            }
        }
        if (response != null) {
            CoAPHelper.convertCoapResponseToMessage(response, exchange.getOut());
        }
        if (method.equalsIgnoreCase("PING")) {
            Message resp = exchange.getOut();
            resp.setBody(pingResponse);
        }
    }

    protected void initClient() throws Exception {
        this.lock.lock();
        try {
            if (this.client == null) {
                this.client = this.endpoint.createCoapClient(this.endpoint.getUri());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
    }
}

