/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.FilteredLogger;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.DtlsClusterHealth;
import org.eclipse.californium.scandium.DtlsClusterHealthLogger;
import org.eclipse.californium.scandium.DtlsHealth;
import org.eclipse.californium.scandium.config.DtlsClusterConnectorConfig;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.NodeConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtlsClusterConnector
extends DTLSConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DtlsClusterConnector.class);
    private final FilteredLogger FILTER = new FilteredLogger(LOGGER.getName(), 3L, TimeUnit.SECONDS.toNanos(10L));
    protected static final int CLUSTER_RECORD_TYPE_OFFSET = 0;
    protected static final int CLUSTER_PORT_OFFSET = 1;
    protected static final int CLUSTER_ADDRESS_LENGTH_OFFSET = 3;
    protected static final int CLUSTER_ADDRESS_OFFSET = 4;
    protected static final int MIN_ADDRESS_LENGTH = 4;
    protected static final int MAX_ADDRESS_LENGTH = 16;
    protected static final int CLUSTER_MAC_LENGTH = 8;
    protected static final int MAX_DATAGRAM_OFFSET = 28;
    public static final Byte RECORD_TYPE_INCOMING = 63;
    public static final Byte RECORD_TYPE_OUTGOING = 62;
    private final NodeConnectionIdGenerator nodeCidGenerator;
    private final List<Thread> clusterReceiverThreads = new LinkedList<Thread>();
    private final boolean startReceiver;
    private final boolean backwardMessages;
    protected final DtlsClusterHealth clusterHealth;
    private final InetSocketAddress clusterInternalSocketAddress;
    protected volatile DatagramSocket clusterInternalSocket;
    private volatile ClusterNodesProvider nodesProvider;

    public DtlsClusterConnector(DtlsConnectorConfig configuration, DtlsClusterConnectorConfig clusterConfiguration, ClusterNodesProvider nodes) {
        this(configuration, clusterConfiguration, DtlsClusterConnector.createConnectionStore(configuration), true);
        this.setClusterNodesProvider(nodes);
    }

    protected DtlsClusterConnector(DtlsConnectorConfig configuration, DtlsClusterConnectorConfig clusterConfiguration, ResumptionSupportingConnectionStore connectionStore, boolean startReceiver) {
        super(configuration, connectionStore);
        this.nodeCidGenerator = this.getNodeConnectionIdGenerator();
        this.clusterInternalSocketAddress = clusterConfiguration.getAddress();
        this.backwardMessages = clusterConfiguration.useBackwardMessages();
        this.clusterHealth = this.health instanceof DtlsClusterHealth ? (DtlsClusterHealth)this.health : null;
        this.startReceiver = startReceiver;
        LOGGER.info("cluster-node {}: on internal {}, backwards {}", new Object[]{this.getNodeID(), StringUtil.toLog(this.clusterInternalSocketAddress), this.backwardMessages});
    }

    private NodeConnectionIdGenerator getNodeConnectionIdGenerator() {
        if (this.connectionIdGenerator == null) {
            throw new IllegalArgumentException("CID generator missing!");
        }
        if (!this.connectionIdGenerator.useConnectionId()) {
            throw new IllegalArgumentException("CID not used!");
        }
        if (!(this.connectionIdGenerator instanceof NodeConnectionIdGenerator)) {
            throw new IllegalArgumentException("CID generator not supports nodes!");
        }
        return (NodeConnectionIdGenerator)this.connectionIdGenerator;
    }

    @Override
    protected DtlsHealth createDefaultHealthHandler(DtlsConnectorConfig configuration) {
        return new DtlsClusterHealthLogger(configuration.getLoggingTag());
    }

    @Override
    protected void init(InetSocketAddress bindAddress, DatagramSocket socket, Integer mtu) throws IOException {
        try {
            this.clusterInternalSocket = new DatagramSocket(this.clusterInternalSocketAddress);
        }
        catch (IOException ex) {
            LOGGER.error("cluster-node {}: management-interface {} failed!", (Object)this.getNodeID(), StringUtil.toLog(this.clusterInternalSocketAddress));
            throw ex;
        }
        super.init(bindAddress, socket, mtu);
        if (this.startReceiver) {
            this.startReceiver();
        }
    }

    protected void startReceiver() {
        int receiverThreadCount = this.config.get(DtlsConfig.DTLS_RECEIVER_THREAD_COUNT);
        for (int i = 0; i < receiverThreadCount; ++i) {
            DTLSConnector.Worker receiver = new DTLSConnector.Worker("DTLS-Cluster-" + this.getNodeID() + "-Receiver-" + i + "-" + this.clusterInternalSocketAddress){
                private final byte[] receiverBuffer;
                private final DatagramPacket clusterPacket;
                {
                    this.receiverBuffer = new byte[DtlsClusterConnector.this.inboundDatagramBufferSize + 28];
                    this.clusterPacket = new DatagramPacket(this.receiverBuffer, this.receiverBuffer.length);
                }

                @Override
                public void doWork() throws Exception {
                    this.clusterPacket.setData(this.receiverBuffer);
                    DtlsClusterConnector.this.clusterInternalSocket.receive(this.clusterPacket);
                    Byte type = DtlsClusterConnector.this.getClusterRecordType(this.clusterPacket);
                    if (type != null) {
                        if (DtlsClusterConnector.this.ensureLength(type, this.clusterPacket)) {
                            DtlsClusterConnector.this.processDatagramFromClusterNetwork(type, this.clusterPacket);
                        } else if (DtlsClusterConnector.this.clusterHealth != null) {
                            DtlsClusterConnector.this.clusterHealth.dropForwardMessage();
                        }
                    } else {
                        DtlsClusterConnector.this.processManagementDatagramFromClusterNetwork(this.clusterPacket);
                    }
                }
            };
            receiver.setDaemon(true);
            receiver.start();
            this.clusterReceiverThreads.add(receiver);
        }
        LOGGER.info("cluster-node {}: started {}", (Object)this.getNodeID(), (Object)this.clusterInternalSocket.getLocalSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        DtlsClusterConnector dtlsClusterConnector = this;
        synchronized (dtlsClusterConnector) {
            this.clusterInternalSocket.close();
            for (Thread t : this.clusterReceiverThreads) {
                t.interrupt();
                try {
                    t.join(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.clusterReceiverThreads.clear();
        }
    }

    protected int getClusterMacLength() {
        return 0;
    }

    public void setClusterNodesProvider(ClusterNodesProvider nodes) {
        this.nodesProvider = nodes;
    }

    public int getNodeID() {
        return this.nodeCidGenerator.getNodeId();
    }

    public InetSocketAddress getClusterInternalAddress() {
        int localPort;
        DatagramSocket socket = this.clusterInternalSocket;
        int n = localPort = socket == null ? -1 : socket.getLocalPort();
        if (localPort < 0) {
            return this.clusterInternalSocketAddress;
        }
        return new InetSocketAddress(socket.getLocalAddress(), localPort);
    }

    protected Byte getClusterRecordType(DatagramPacket clusterPacket) {
        byte type = clusterPacket.getData()[clusterPacket.getOffset() + 0];
        if (type == RECORD_TYPE_INCOMING) {
            return RECORD_TYPE_INCOMING;
        }
        if (type == RECORD_TYPE_OUTGOING) {
            return RECORD_TYPE_OUTGOING;
        }
        return null;
    }

    protected boolean ensureLength(Byte type, DatagramPacket clusterPacket) {
        int macLength;
        int offset;
        int length = clusterPacket.getLength();
        if (length < 33) {
            return false;
        }
        byte[] data = clusterPacket.getData();
        int addressLength = data[(offset = clusterPacket.getOffset()) + 3] & 0xFF;
        return length > 4 + addressLength + (macLength = this.getClusterMacLength()) + 25;
    }

    protected void processDatagramFromClusterNetwork(Byte type, DatagramPacket clusterPacket) throws IOException {
        InetSocketAddress router = (InetSocketAddress)clusterPacket.getSocketAddress();
        DatagramPacket packet = this.decode(clusterPacket);
        if (packet == null) {
            if (this.clusterHealth != null) {
                this.clusterHealth.dropForwardMessage();
            }
            return;
        }
        if (RECORD_TYPE_INCOMING.equals(type)) {
            LOGGER.trace("cluster-node {}: received forwarded message", (Object)this.getNodeID());
            super.processDatagram(packet, router);
            if (this.clusterHealth != null) {
                this.clusterHealth.processForwardedMessage();
            }
        } else if (RECORD_TYPE_OUTGOING.equals(type)) {
            LOGGER.trace("cluster-node {}: received backwarded outgoing message", (Object)this.getNodeID());
            super.sendNextDatagramOverNetwork(packet);
            if (this.clusterHealth != null) {
                this.clusterHealth.sendBackwardedMessage();
            }
        }
    }

    protected void processManagementDatagramFromClusterNetwork(DatagramPacket clusterPacket) throws IOException {
    }

    protected void sendDatagramToClusterNetwork(DatagramPacket clusterPacket) throws IOException {
        this.clusterInternalSocket.send(clusterPacket);
    }

    @Override
    protected void processDatagram(DatagramPacket packet, InetSocketAddress router) {
        int offset = packet.getOffset();
        int length = packet.getLength();
        byte[] data = packet.getData();
        InetSocketAddress source = (InetSocketAddress)packet.getSocketAddress();
        if (data[offset] == ContentType.TLS12_CID.getCode()) {
            if (length > 13) {
                DatagramReader reader = new DatagramReader(data, offset, length);
                ConnectionId cid = Record.readConnectionIdFromReader(reader, this.connectionIdGenerator);
                if (cid != null) {
                    int incomingNodeId = this.nodeCidGenerator.getNodeId(cid);
                    if (this.getNodeID() != incomingNodeId) {
                        LOGGER.trace("cluster-node {}: received foreign message for {} from {}", new Object[]{this.getNodeID(), incomingNodeId, StringUtil.toLog(source)});
                        InetSocketAddress clusterNode = this.nodesProvider.getClusterNode(incomingNodeId);
                        if (clusterNode != null) {
                            DatagramPacket clusterPacket = this.encode(RECORD_TYPE_INCOMING, packet, null);
                            clusterPacket.setSocketAddress(clusterNode);
                            try {
                                LOGGER.trace("cluster-node {}: forwards received message from {} to {}, {} bytes", new Object[]{this.getNodeID(), StringUtil.toLog(source), StringUtil.toLog(clusterNode), length});
                                this.sendDatagramToClusterNetwork(clusterPacket);
                                if (this.clusterHealth != null) {
                                    this.clusterHealth.forwardMessage();
                                }
                                return;
                            }
                            catch (IOException e) {
                                LOGGER.info("cluster-node {}: error forwarding to {}/{}:", new Object[]{this.getNodeID(), incomingNodeId, StringUtil.toLog(clusterNode), e});
                                if (this.clusterHealth != null) {
                                    this.clusterHealth.dropForwardMessage();
                                }
                                this.health.receivingRecord(true);
                            }
                        } else {
                            this.FILTER.debug("cluster-node {}: received foreign message from {} for unknown node {}, {} bytes, dropping.", this.getNodeID(), StringUtil.toLog(source), incomingNodeId, length);
                            if (this.clusterHealth != null) {
                                this.clusterHealth.dropForwardMessage();
                            } else {
                                this.health.receivingRecord(true);
                            }
                        }
                    } else {
                        LOGGER.trace("cluster-node {}: received own message from {}, {} bytes", new Object[]{this.getNodeID(), StringUtil.toLog(source), length});
                    }
                } else {
                    this.FILTER.debug("cluster-node {}: received broken CID message from {}", this.getNodeID(), StringUtil.toLog(source));
                }
            } else {
                this.FILTER.debug("cluster-node {}: received too short CID message from {}", this.getNodeID(), StringUtil.toLog(source));
            }
        } else {
            LOGGER.trace("cluster-node {}: received no CID message from {}, {} bytes.", new Object[]{this.getNodeID(), StringUtil.toLog(source), length});
        }
        super.processDatagram(packet, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void sendRecord(Record record) throws IOException {
        InetSocketAddress destination = record.getPeerAddress();
        InetSocketAddress router = record.getRouter();
        if (router != null && this.backwardMessages) {
            if (!this.nodesProvider.available(router)) {
                if (this.clusterHealth == null) throw new IOException("Cluster internal destination " + StringUtil.toString(router) + " not longer available!");
                this.clusterHealth.dropBackwardMessage();
                throw new IOException("Cluster internal destination " + StringUtil.toString(router) + " not longer available!");
            }
            byte[] recordBytes = record.toByteArray();
            int length = recordBytes.length;
            byte[] datagramBytes = new byte[length + 28];
            LOGGER.trace("cluster-node {}: backwards send message for {} to {}, {} bytes", new Object[]{this.getNodeID(), StringUtil.toLog(destination), router, length});
            DatagramPacket datagram = new DatagramPacket(datagramBytes, datagramBytes.length, destination);
            DatagramPacket clusterPacket = this.encode(RECORD_TYPE_OUTGOING, datagram, recordBytes);
            clusterPacket.setSocketAddress(router);
            try {
                this.sendDatagramToClusterNetwork(clusterPacket);
                if (this.clusterHealth == null) return;
                this.clusterHealth.backwardMessage();
                return;
            }
            catch (IOException ex) {
                LOGGER.debug("cluster-node {}: sending internal message failed!", (Object)this.getNodeID(), (Object)ex);
                if (this.clusterHealth == null) throw ex;
                this.clusterHealth.dropBackwardMessage();
                throw ex;
            }
        }
        LOGGER.trace("cluster-node {}: sends message to {}, {} bytes", new Object[]{this.getNodeID(), StringUtil.toLog(destination), record.size()});
        super.sendRecord(record);
    }

    private DatagramPacket encode(byte direction, DatagramPacket packet, byte[] recordBytes) {
        int length;
        InetAddress source = packet.getAddress();
        byte[] address = source.getAddress();
        int headerLength = 4 + address.length + this.getClusterMacLength();
        byte[] data = packet.getData();
        if (recordBytes == null) {
            int offset = packet.getOffset();
            length = packet.getLength();
            if (offset != headerLength) {
                System.arraycopy(data, offset, data, headerLength, length);
            }
        } else {
            boolean offset = false;
            length = recordBytes.length;
            System.arraycopy(recordBytes, 0, data, headerLength, length);
        }
        data[0] = direction;
        data[1] = (byte)packet.getPort();
        data[2] = (byte)(packet.getPort() >> 8);
        data[3] = (byte)address.length;
        System.arraycopy(address, 0, data, 4, address.length);
        packet.setData(data, 0, length + headerLength);
        return packet;
    }

    private DatagramPacket decode(DatagramPacket packet) {
        try {
            byte[] data = packet.getData();
            int offset = packet.getOffset();
            int length = packet.getLength();
            int addressLength = data[offset + 3] & 0xFF;
            int port = data[offset + 1] & 0xFF | (data[offset + 1 + 1] & 0xFF) << 8;
            byte[] address = Arrays.copyOfRange(data, offset + 4, offset + 4 + addressLength);
            int headerLength = 4 + addressLength + this.getClusterMacLength();
            InetAddress iaddr = InetAddress.getByAddress(address);
            packet.setAddress(iaddr);
            packet.setPort(port);
            packet.setData(data, offset + headerLength, length - headerLength);
            return packet;
        }
        catch (UnknownHostException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static interface ClusterNodesProvider {
        public InetSocketAddress getClusterNode(int var1);

        public boolean available(InetSocketAddress var1);
    }
}

