/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.DtlsHealth;
import org.eclipse.californium.scandium.DtlsHealthExtended;
import org.eclipse.californium.scandium.DtlsHealthExtended2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoPublicAPI
public class DtlsHealthLogger
extends CounterStatisticManager
implements DtlsHealth,
DtlsHealthExtended,
DtlsHealthExtended2 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(DTLSConnector.class.getCanonicalName() + ".health"));
    public static final String DROPPED_UDP_MESSAGES = "dropped udp messages";
    private final AtomicInteger pendingHandshakes = new AtomicInteger();
    protected final SimpleCounterStatistic.AlignGroup align = new SimpleCounterStatistic.AlignGroup();
    private final SimpleCounterStatistic connections = new SimpleCounterStatistic("connections", this.align);
    private final SimpleCounterStatistic succeededHandshakes = new SimpleCounterStatistic("handshakes succeeded", this.align);
    private final SimpleCounterStatistic failedHandshakes = new SimpleCounterStatistic("handshakes failed", this.align);
    private final SimpleCounterStatistic receivedRecords = new SimpleCounterStatistic("received records", this.align);
    private final SimpleCounterStatistic droppedReceivedRecords = new SimpleCounterStatistic("dropped received records", this.align);
    private final SimpleCounterStatistic droppedReceivedMacErrors = new SimpleCounterStatistic("dropped received mac-errors", this.align);
    private final SimpleCounterStatistic sentRecords = new SimpleCounterStatistic("sending records", this.align);
    private final SimpleCounterStatistic droppedSentRecords = new SimpleCounterStatistic("dropped sending records", this.align);
    private final SimpleCounterStatistic droppedMessages = new SimpleCounterStatistic("dropped udp messages", this.align);
    private final SimpleCounterStatistic pendingIncoming = new SimpleCounterStatistic("pending in jobs", this.align);
    private final SimpleCounterStatistic pendingOutgoing = new SimpleCounterStatistic("pending out jobs", this.align);
    private final SimpleCounterStatistic pendingHandshakeJobs = new SimpleCounterStatistic("pending handshake jobs", this.align);

    public DtlsHealthLogger() {
        this("");
    }

    public DtlsHealthLogger(String tag) {
        super(tag);
        this.init();
    }

    public DtlsHealthLogger(String tag, int interval, TimeUnit unit, ScheduledExecutorService executor) {
        super(tag, interval, unit, executor);
        this.init();
    }

    private void init() {
        this.add(this.connections);
        this.add(this.succeededHandshakes);
        this.add(this.failedHandshakes);
        this.add(this.receivedRecords);
        this.add(this.droppedReceivedRecords);
        this.add(this.droppedReceivedMacErrors);
        this.add(this.sentRecords);
        this.add(this.droppedSentRecords);
        this.add(this.droppedMessages);
        this.add(this.pendingIncoming);
        this.add(this.pendingOutgoing);
        this.add(this.pendingHandshakeJobs);
    }

    @Override
    public void dump() {
        try {
            if (this.isEnabled()) {
                if (this.isUsed() && LOGGER.isDebugEnabled()) {
                    String eol = StringUtil.lineSeparator();
                    String head = "   " + this.tag;
                    StringBuilder log = new StringBuilder();
                    log.append(this.tag).append("dtls statistic:").append(eol);
                    log.append(head).append(this.connections).append(eol);
                    log.append(head).append(this.succeededHandshakes).append(eol);
                    log.append(head).append(this.failedHandshakes).append(eol);
                    log.append(head).append(this.sentRecords).append(eol);
                    log.append(head).append(this.droppedSentRecords).append(eol);
                    log.append(head).append(this.receivedRecords).append(eol);
                    log.append(head).append(this.droppedReceivedRecords).append(eol);
                    log.append(head).append(this.droppedReceivedMacErrors);
                    if (this.droppedMessages.isStarted()) {
                        log.append(eol).append(head).append(this.droppedMessages);
                    }
                    log.append(eol).append(head).append(this.pendingIncoming);
                    log.append(eol).append(head).append(this.pendingOutgoing);
                    log.append(eol).append(head).append(this.pendingHandshakeJobs);
                    this.dump(head, log);
                    LOGGER.debug("{}", (Object)log);
                }
                this.transferCounter();
            }
        }
        catch (Throwable e) {
            LOGGER.error("{}", (Object)this.tag, (Object)e);
        }
    }

    @Override
    public void dump(String tag, int maxConnections, int remainingCapacity, int pendingWithoutVerify) {
        try {
            if (this.isEnabled()) {
                this.connections.transferCounter();
                this.connections.set(maxConnections - remainingCapacity);
                if (this.isUsed() && LOGGER.isDebugEnabled()) {
                    String eol = StringUtil.lineSeparator();
                    String head = "   " + tag;
                    String associations = "associations";
                    String handshakes = "handshakes pending";
                    this.align.add(associations);
                    this.align.add(handshakes);
                    StringBuilder log = new StringBuilder();
                    log.append(tag).append("dtls statistic:").append(eol);
                    String msg = SimpleCounterStatistic.format(this.align.getAlign(), associations, maxConnections - remainingCapacity);
                    log.append(head).append(msg);
                    log.append(" (").append(remainingCapacity).append(" remaining capacity).").append(eol);
                    msg = SimpleCounterStatistic.format(this.align.getAlign(), handshakes, this.pendingHandshakes.get());
                    log.append(head).append(msg);
                    log.append(" (").append(pendingWithoutVerify).append(" without verify).").append(eol);
                    log.append(head).append(this.succeededHandshakes).append(eol);
                    log.append(head).append(this.failedHandshakes).append(eol);
                    log.append(head).append(this.sentRecords).append(eol);
                    log.append(head).append(this.droppedSentRecords).append(eol);
                    log.append(head).append(this.receivedRecords).append(eol);
                    log.append(head).append(this.droppedReceivedRecords).append(eol);
                    log.append(head).append(this.droppedReceivedMacErrors);
                    if (this.droppedMessages.isStarted()) {
                        log.append(eol).append(head).append(this.droppedMessages);
                    }
                    log.append(eol).append(head).append(this.pendingIncoming);
                    log.append(eol).append(head).append(this.pendingOutgoing);
                    log.append(eol).append(head).append(this.pendingHandshakeJobs);
                    this.dump(head, log);
                    LOGGER.debug("{}", (Object)log);
                }
                this.transferCounter();
            }
        }
        catch (Throwable e) {
            LOGGER.error("{}", (Object)tag, (Object)e);
        }
    }

    protected boolean isUsed() {
        return this.receivedRecords.isUsed() || this.sentRecords.isUsed();
    }

    protected void dump(String head, StringBuilder log) {
    }

    @Override
    public boolean isEnabled() {
        return LOGGER.isInfoEnabled();
    }

    @Override
    public void startHandshake() {
        this.pendingHandshakes.incrementAndGet();
    }

    @Override
    public void endHandshake(boolean success) {
        this.pendingHandshakes.decrementAndGet();
        if (success) {
            this.succeededHandshakes.increment();
        } else {
            this.failedHandshakes.increment();
        }
    }

    @Override
    public void receivingRecord(boolean drop) {
        if (drop) {
            this.droppedReceivedRecords.increment();
        } else {
            this.receivedRecords.increment();
        }
    }

    @Override
    public void sendingRecord(boolean drop) {
        if (drop) {
            this.droppedSentRecords.increment();
        } else {
            this.sentRecords.increment();
        }
    }

    @Override
    public void receivingMacError() {
        this.droppedReceivedMacErrors.increment();
    }

    @Override
    public void setConnections(int count) {
        this.connections.set(count);
    }

    @Override
    public void setPendingIncomingJobs(int count) {
        this.pendingIncoming.set(count);
    }

    @Override
    public void setPendingOutgoingJobs(int count) {
        this.pendingOutgoing.set(count);
    }

    @Override
    public void setPendingHandshakeJobs(int count) {
        this.pendingHandshakeJobs.set(count);
    }
}

