/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSContext;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.slf4j.MDC;

public class MdcConnectionListener
implements ConnectionListener {
    @Override
    public void onConnectionEstablished(Connection connection) {
    }

    @Override
    public void onConnectionRemoved(Connection connection) {
    }

    @Override
    public boolean onConnectionUpdatesSequenceNumbers(Connection connection, boolean writeSequenceNumber) {
        return false;
    }

    @Override
    public boolean onConnectionMacError(Connection connection) {
        return false;
    }

    @Override
    public void beforeExecution(Connection connection) {
        if (DTLSConnector.MDC_SUPPORT) {
            SessionId sid;
            DTLSSession session;
            ConnectionId writeConnectionId;
            DTLSContext context;
            ConnectionId cid;
            InetSocketAddress peerAddress = connection.getPeerAddress();
            if (peerAddress != null) {
                MDC.put((String)"PEER", (String)StringUtil.toString(peerAddress));
            }
            if ((cid = connection.getConnectionId()) != null) {
                MDC.put((String)"CONNECTION_ID", (String)cid.getAsString());
            }
            if ((context = connection.getEstablishedDtlsContext()) != null && (writeConnectionId = context.getWriteConnectionId()) != null && !writeConnectionId.isEmpty()) {
                MDC.put((String)"WRITE_CONNECTION_ID", (String)writeConnectionId.getAsString());
            }
            if ((session = connection.getSession()) != null && (sid = session.getSessionIdentifier()) != null && !sid.isEmpty()) {
                MDC.put((String)"SESSION_ID", (String)sid.toString());
            }
        }
    }

    @Override
    public void updateExecution(Connection connection) {
        this.beforeExecution(connection);
    }

    @Override
    public void afterExecution(Connection connection) {
        if (DTLSConnector.MDC_SUPPORT) {
            MDC.clear();
        }
    }
}

