/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

@NoPublicAPI
public abstract class ECDHServerKeyExchange
extends ServerKeyExchange {
    private static final int CURVE_TYPE_BITS = 8;
    private static final int NAMED_CURVE_BITS = 16;
    private static final int PUBLIC_LENGTH_BITS = 8;
    private static final int NAMED_CURVE = 3;
    private final XECDHECryptography.SupportedGroup supportedGroup;
    private final byte[] encodedPoint;

    protected ECDHServerKeyExchange(XECDHECryptography.SupportedGroup supportedGroup, byte[] encodedPoint) {
        if (supportedGroup == null) {
            throw new NullPointerException("Supported group (curve) must not be null!");
        }
        if (encodedPoint == null) {
            throw new NullPointerException("encoded point must not be null!");
        }
        this.supportedGroup = supportedGroup;
        this.encodedPoint = encodedPoint;
    }

    protected int getNamedCurveLength() {
        return 4 + this.encodedPoint.length;
    }

    protected void writeNamedCurve(DatagramWriter writer) {
        writer.write(3, 8);
        writer.write(this.supportedGroup.getId(), 16);
        writer.writeVarBytes(this.encodedPoint, 8);
    }

    protected static EcdhData readNamedCurve(DatagramReader reader) throws HandshakeException {
        int curveType = reader.read(8);
        if (curveType != 3) {
            throw new HandshakeException(String.format("Curve type [%s] received in ServerKeyExchange message is unsupported", curveType), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        int curveId = reader.read(16);
        XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromId(curveId);
        if (group == null || !group.isUsable()) {
            throw new HandshakeException(String.format("Server used unsupported elliptic curve (%d) for ECDH", curveId), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        byte[] encodedPoint = reader.readVarBytes(8);
        return new EcdhData(group, encodedPoint);
    }

    protected void updateSignatureForNamedCurve(Signature signature) throws SignatureException {
        int curveId = this.getSupportedGroup().getId();
        signature.update((byte)3);
        signature.update((byte)(curveId >> 8));
        signature.update((byte)curveId);
        signature.update((byte)this.encodedPoint.length);
        signature.update(this.encodedPoint);
    }

    public XECDHECryptography.SupportedGroup getSupportedGroup() {
        return this.supportedGroup;
    }

    public byte[] getEncodedPoint() {
        return Arrays.copyOf(this.encodedPoint, this.encodedPoint.length);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        sb.append(indentation).append("Diffie-Hellman public key: ");
        sb.append(this.supportedGroup.name()).append("-").append(StringUtil.byteArray2HexString(this.encodedPoint, '\u0000', 16));
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }

    protected static class EcdhData {
        public final XECDHECryptography.SupportedGroup supportedGroup;
        public final byte[] encodedPoint;

        EcdhData(XECDHECryptography.SupportedGroup supportedGroup, byte[] encodedPoint) {
            this.supportedGroup = supportedGroup;
            this.encodedPoint = encodedPoint;
        }
    }
}

