/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalSignature;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoPublicAPI
public final class EcdhSignedServerKeyExchange
extends ECDHServerKeyExchange {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcdhSignedServerKeyExchange.class);
    private static final int HASH_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_LENGTH_BITS = 16;
    private final byte[] signatureEncoded;
    private final SignatureAndHashAlgorithm signatureAndHashAlgorithm;

    public EcdhSignedServerKeyExchange(SignatureAndHashAlgorithm signatureAndHashAlgorithm, XECDHECryptography ecdhe, PrivateKey serverPrivateKey, Random clientRandom, Random serverRandom) throws HandshakeException {
        super(ecdhe.getSupportedGroup(), ecdhe.getEncodedPoint());
        if (signatureAndHashAlgorithm == null) {
            throw new NullPointerException("signature and hash algorithm cannot be null");
        }
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        ThreadLocalSignature localSignature = signatureAndHashAlgorithm.getThreadLocalSignature();
        try {
            Signature signature = (Signature)localSignature.currentWithCause();
            signature.initSign(serverPrivateKey, RandomManager.currentSecureRandom());
            this.updateSignature(signature, clientRandom, serverRandom);
            this.signatureEncoded = signature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new HandshakeException(String.format("Server failed to sign key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
    }

    private EcdhSignedServerKeyExchange(SignatureAndHashAlgorithm signatureAndHashAlgorithm, XECDHECryptography.SupportedGroup supportedGroup, byte[] encodedPoint, byte[] signatureEncoded) {
        super(supportedGroup, encodedPoint);
        if (signatureAndHashAlgorithm == null && signatureEncoded != null) {
            throw new NullPointerException("signature and hash algorithm cannot be null");
        }
        if (signatureAndHashAlgorithm != null && signatureEncoded == null) {
            throw new NullPointerException("signature cannot be null");
        }
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        this.signatureEncoded = signatureEncoded;
    }

    @Override
    public int getMessageLength() {
        int signatureLength = this.signatureEncoded == null ? 0 : 4 + this.signatureEncoded.length;
        return this.getNamedCurveLength() + signatureLength;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        this.writeNamedCurve(writer);
        if (this.signatureEncoded != null) {
            writer.write(this.signatureAndHashAlgorithm.getHash().getCode(), 8);
            writer.write(this.signatureAndHashAlgorithm.getSignature().getCode(), 8);
            writer.writeVarBytes(this.signatureEncoded, 16);
        }
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader) throws HandshakeException {
        ECDHServerKeyExchange.EcdhData ecdhData = EcdhSignedServerKeyExchange.readNamedCurve(reader);
        SignatureAndHashAlgorithm signAndHash = null;
        byte[] signatureEncoded = null;
        if (reader.bytesAvailable()) {
            int hashAlgorithm = reader.read(8);
            int signatureAlgorithm = reader.read(8);
            signAndHash = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
            signatureEncoded = reader.readVarBytes(16);
        }
        return new EcdhSignedServerKeyExchange(signAndHash, ecdhData.supportedGroup, ecdhData.encodedPoint, signatureEncoded);
    }

    public void verifySignature(PublicKey serverPublicKey, Random clientRandom, Random serverRandom) throws HandshakeException {
        if (this.signatureEncoded == null) {
            String message = "The server's ECDHE key exchange message has no signature.";
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECRYPT_ERROR);
            throw new HandshakeException(message, alert);
        }
        try {
            ThreadLocalSignature localSignature = this.signatureAndHashAlgorithm.getThreadLocalSignature();
            Signature signature = (Signature)localSignature.currentWithCause();
            signature.initVerify(serverPublicKey);
            this.updateSignature(signature, clientRandom, serverRandom);
            if (signature.verify(this.signatureEncoded)) {
                if (JceProviderUtil.isEcdsaVulnerable() && this.signatureAndHashAlgorithm.getSignature() == SignatureAndHashAlgorithm.SignatureAlgorithm.ECDSA) {
                    Asn1DerDecoder.checkEcDsaSignature(this.signatureEncoded, serverPublicKey);
                }
                return;
            }
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not verify the server's signature.", (Throwable)e);
        }
        String message = "The server's ECDHE key exchange message's signature could not be verified.";
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECRYPT_ERROR);
        throw new HandshakeException(message, alert);
    }

    private void updateSignature(Signature signature, Random clientRandom, Random serverRandom) throws SignatureException {
        signature.update(clientRandom.getBytes());
        signature.update(serverRandom.getBytes());
        this.updateSignatureForNamedCurve(signature);
    }

    @Override
    public String toString(int indent) {
        String text = super.toString(indent);
        if (this.signatureEncoded != null) {
            StringBuilder sb = new StringBuilder(text);
            String indentation = StringUtil.indentation(indent + 1);
            sb.append(indentation).append("Signature: ");
            sb.append(this.signatureAndHashAlgorithm).append("-");
            sb.append(StringUtil.byteArray2HexString(this.signatureEncoded, '\u0000', 16));
            sb.append(StringUtil.lineSeparator());
            text = sb.toString();
        }
        return text;
    }
}

