/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.EncryptedStreamUtil;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.elements.util.SystemResourceMonitors;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPskFileStore
implements AdvancedPskStore,
Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiPskFileStore.class);
    private final EncryptedStreamUtil encryptionUtility = new EncryptedStreamUtil();
    private volatile Credentials credentials = new Credentials();
    private volatile boolean destroyed;
    private byte[] seed;

    public String getWriteCipher() {
        return this.encryptionUtility.getWriteCipher();
    }

    public String getReadCipher() {
        return this.encryptionUtility.getReadCipher();
    }

    @Deprecated
    public void setCipher(String cipherAlgorithm, int keySizeBits) {
        this.encryptionUtility.setCipher(cipherAlgorithm, keySizeBits);
    }

    public void setDefaultWriteCipher() {
        this.encryptionUtility.setDefaultWriteCipher();
    }

    public void setWriteCipher(String cipherAlgorithm, int keySizeBits) {
        this.encryptionUtility.setWriteCipher(cipherAlgorithm, keySizeBits);
    }

    public void setWriteCipher(String spec) {
        this.encryptionUtility.setWriteCipher(spec);
    }

    public SystemResourceMonitors.SystemResourceMonitor getMonitor(final String file, final SecretKey password) {
        return new SystemResourceMonitors.FileMonitor(file){
            private SecretKey monitorPassword;
            {
                super(arg0);
                this.monitorPassword = SecretUtil.create(password);
            }

            @Override
            protected void update(SystemResourceMonitors.FileMonitor.MonitoredValues values, SystemResourceMonitors.SystemResourceCheckReady ready) {
                if (file != null) {
                    if (this.monitorPassword != null) {
                        MultiPskFileStore.this.loadPskCredentials(file, this.monitorPassword);
                    } else {
                        MultiPskFileStore.this.loadPskCredentials(file);
                    }
                }
                this.ready(values);
                ready.ready(false);
            }
        };
    }

    public void clearSeed() {
        this.seed = null;
    }

    public MultiPskFileStore loadPskCredentials(String file) {
        try (FileInputStream in = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
            this.loadPskCredentials(reader);
        }
        catch (IOException e) {
            LOGGER.warn("read psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore loadPskCredentials(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            this.loadPskCredentials(reader);
        }
        catch (IOException e) {
            LOGGER.warn("read psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore loadPskCredentials(String file, SecretKey password) {
        try (FileInputStream in = new FileInputStream(file);){
            this.loadPskCredentials(in, password);
        }
        catch (IOException e) {
            LOGGER.warn("read psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore loadPskCredentials(InputStream in, SecretKey password) {
        byte[] seed = this.encryptionUtility.readSeed(in);
        if (this.seed == null && !Arrays.equals(this.seed, seed)) {
            try (InputStream inEncrypted = this.encryptionUtility.prepare(seed, in, password);){
                this.loadPskCredentials(inEncrypted);
                this.seed = seed;
            }
            catch (IOException e) {
                LOGGER.warn("read psk-store:", (Throwable)e);
            }
        } else {
            LOGGER.debug("Encrypted PSK store no changed seed.");
        }
        return this;
    }

    public MultiPskFileStore loadPskCredentials(Reader reader) throws IOException {
        Credentials newCredentials = new Credentials();
        newCredentials.loadPskCredentials(reader);
        if (newCredentials.isDestroyed()) {
            if (this.credentials.size() == 0) {
                this.destroyed = true;
            }
        } else {
            this.credentials = newCredentials;
            this.seed = null;
        }
        return this;
    }

    public MultiPskFileStore savePskCredentials(String file) {
        try (FileOutputStream out = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            this.savePskCredentials(writer);
        }
        catch (IOException e) {
            LOGGER.warn("write psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore savePskCredentials(OutputStream out) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            this.savePskCredentials(writer);
        }
        catch (IOException e) {
            LOGGER.warn("write psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore savePskCredentials(String file, SecretKey password) {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.savePskCredentials(out, password);
        }
        catch (IOException e) {
            LOGGER.warn("write psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore savePskCredentials(OutputStream out, SecretKey password) {
        try (OutputStream outEncrypted = this.encryptionUtility.prepare(this.seed, out, password);){
            this.savePskCredentials(outEncrypted);
        }
        catch (IOException e) {
            LOGGER.warn("write psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore savePskCredentials(Writer writer) throws IOException {
        this.credentials.savePskCredentials(writer);
        return this;
    }

    public MultiPskFileStore addKey(PskPublicInformation identity, SecretKey secret) {
        if (identity.getPublicInfoAsString().indexOf(61) >= 0) {
            throw new IllegalArgumentException("Identity must not contain '='!");
        }
        this.credentials.add(identity, SecretUtil.create(secret));
        return this;
    }

    public MultiPskFileStore addKey(String identity, SecretKey secret) {
        return this.addKey(new PskPublicInformation(identity), secret);
    }

    public MultiPskFileStore removeKey(PskPublicInformation identity) {
        this.credentials.remove(identity);
        return this;
    }

    public MultiPskFileStore removeKey(int index) {
        this.credentials.remove(index);
        return this;
    }

    public MultiPskFileStore removeKey(String identity) {
        return this.removeKey(new PskPublicInformation(identity));
    }

    public String getIdentity(int index) {
        return this.credentials.getIdentity(index);
    }

    public SecretKey getSecret(int index) {
        return this.credentials.getSecret(index);
    }

    public SecretKey getSecret(String identity) {
        return this.getSecret(new PskPublicInformation(identity));
    }

    public SecretKey getSecret(PskPublicInformation identity) {
        return this.credentials.getSecret(identity);
    }

    public int size() {
        return this.credentials.size();
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.credentials.destroy();
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean hasEcdhePskSupported() {
        return true;
    }

    @Override
    public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        return new PskSecretResult(cid, identity, this.credentials.getSecret(identity));
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return null;
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    private static class Credentials
    implements Destroyable {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final List<PskPublicInformation> identities = new ArrayList<PskPublicInformation>();
        private final Map<PskPublicInformation, SecretKey> keys = new HashMap<PskPublicInformation, SecretKey>();
        private volatile boolean destroyed;

        private Credentials() {
        }

        private void add(PskPublicInformation id, SecretKey key) {
            this.lock.writeLock().lock();
            try {
                if (this.keys.put(id, key) == null) {
                    this.identities.add(id);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private void remove(PskPublicInformation id) {
            this.lock.writeLock().lock();
            try {
                SecretKey key = this.keys.remove(id);
                if (key != null) {
                    SecretUtil.destroy(key);
                    this.identities.remove(id);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(int index) {
            this.lock.writeLock().lock();
            try {
                SecretKey key;
                PskPublicInformation id = this.identities.remove(index);
                if (id != null && (key = this.keys.remove(id)) != null) {
                    SecretUtil.destroy(key);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private SecretKey getSecret(PskPublicInformation id) {
            SecretKey key = null;
            this.lock.readLock().lock();
            try {
                key = this.keys.get(id);
            }
            finally {
                this.lock.readLock().unlock();
            }
            return SecretUtil.create(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SecretKey getSecret(int index) {
            this.lock.readLock().lock();
            try {
                PskPublicInformation info = this.identities.get(index);
                if (info != null) {
                    SecretKey secretKey = this.getSecret(info);
                    return secretKey;
                }
                SecretKey secretKey = null;
                return secretKey;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private String getIdentity(int index) {
            PskPublicInformation info = null;
            this.lock.readLock().lock();
            try {
                info = this.identities.get(index);
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (info != null) {
                return info.getPublicInfoAsString();
            }
            return null;
        }

        private int size() {
            this.lock.readLock().lock();
            try {
                int n = this.identities.size();
                return n;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void savePskCredentials(Writer writer) throws IOException {
            for (PskPublicInformation identity : this.identities) {
                SecretKey secretKey = this.keys.get(identity);
                if (secretKey == null) continue;
                byte[] key = secretKey.getEncoded();
                char[] base64 = StringUtil.byteArrayToBase64CharArray(key);
                Bytes.clear(key);
                writer.write(identity.getPublicInfoAsString());
                writer.write(61);
                writer.write(base64);
                writer.write(StringUtil.lineSeparator());
                Arrays.fill(base64, '.');
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadPskCredentials(Reader reader) throws IOException {
            block19: {
                BufferedReader lineReader = new BufferedReader(reader);
                try {
                    String line;
                    int lineNumber = 0;
                    int errors = 0;
                    int comments = 0;
                    while ((line = lineReader.readLine()) != null) {
                        ++lineNumber;
                        try {
                            if (!line.isEmpty() && !line.startsWith("#")) {
                                String[] entry = line.split("=", 2);
                                if (entry.length == 2) {
                                    byte[] secretBytes = entry[1].startsWith(":0x") ? StringUtil.hex2ByteArray(entry[1].substring(3)) : StringUtil.base64ToByteArray(entry[1]);
                                    if (secretBytes.length == 0) {
                                        LOGGER.warn("{}: '{}' invalid base64 secret in psk-line!", (Object)lineNumber, (Object)line);
                                        ++errors;
                                        continue;
                                    }
                                    SecretKey key = SecretUtil.create(secretBytes, "PSK");
                                    Bytes.clear(secretBytes);
                                    PskPublicInformation id = new PskPublicInformation(entry[0]);
                                    this.add(id, key);
                                    continue;
                                }
                                ++errors;
                                LOGGER.warn("{}: '{}' invalid psk-line entries!", (Object)lineNumber, (Object)line);
                                continue;
                            }
                            ++comments;
                        }
                        catch (IllegalArgumentException ex) {
                            ++errors;
                            LOGGER.warn("{}: '{}' invalid psk-line!", new Object[]{lineNumber, line, ex});
                        }
                    }
                    if (this.size() == 0 && errors > 0 && lineNumber == comments + errors) {
                        LOGGER.warn("read psk-store, only errors, wrong password?");
                        SecretUtil.destroy(this);
                    }
                }
                catch (IOException e) {
                    if (e.getCause() instanceof GeneralSecurityException) {
                        LOGGER.warn("read psk-store, wrong password?", (Throwable)e);
                        SecretUtil.destroy(this);
                        break block19;
                    }
                    throw e;
                }
                finally {
                    try {
                        lineReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            LOGGER.info("read {} PSK credentials.", (Object)this.size());
        }

        @Override
        public void destroy() throws DestroyFailedException {
            this.lock.writeLock().lock();
            try {
                this.identities.clear();
                for (SecretKey credentials : this.keys.values()) {
                    SecretUtil.destroy(credentials);
                }
                this.keys.clear();
                this.destroyed = true;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public boolean isDestroyed() {
            return this.destroyed;
        }
    }
}

