/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.coap.CamelCoapResource;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoAPNotifier
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CoAPNotifier.class);
    private final CoAPEndpoint endpoint;

    public CoAPNotifier(CoAPEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        URI uri = this.endpoint.getUri();
        CamelCoapResource resource = this.endpoint.getCamelCoapResource(uri.getPath());
        if (resource == null) {
            throw new IllegalStateException("Resource not found: " + String.valueOf(this.endpoint.getUri()));
        }
        if (!resource.isObservable()) {
            LOG.warn("Ignoring notification attempt for resource that is not observable: {}", (Object)this.endpoint.getUri());
            return;
        }
        resource.changed(observeRelation -> {
            if (uri.getPath().equals(resource.getPath() + resource.getName())) {
                return true;
            }
            String observedPath = observeRelation.getExchange().getRequest().getOptions().getUriPathString();
            return uri.getPath().equals(observedPath);
        });
    }
}

