/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.BaseMatcher;
import org.eclipse.californium.core.network.EndpointReceiver;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.KeyMID;
import org.eclipse.californium.core.network.KeyToken;
import org.eclipse.californium.core.network.MessageExchangeStore;
import org.eclipse.californium.core.network.RemoveHandler;
import org.eclipse.californium.core.network.TokenGenerator;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UdpMatcher
extends BaseMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpMatcher.class);
    private final RemoveHandler exchangeRemoveHandler = new RemoveHandlerImpl();
    private final EndpointContextMatcher endpointContextMatcher;

    public UdpMatcher(Configuration config, NotificationListener notificationListener, TokenGenerator tokenGenerator, ObservationStore observationStore, MessageExchangeStore exchangeStore, Executor executor, EndpointContextMatcher matchingStrategy) {
        super(config, notificationListener, tokenGenerator, observationStore, exchangeStore, matchingStrategy, executor);
        this.endpointContextMatcher = matchingStrategy;
    }

    @Override
    public void sendRequest(Exchange exchange) {
        Request request = exchange.getCurrentRequest();
        if (request.isObserve() && 0 == exchange.getFailedTransmissionCount()) {
            if (this.exchangeStore.assignMessageId(request) != -1) {
                this.registerObserve(request);
            } else {
                LOGGER.debug("message IDs exhausted, could not register outbound observe request for tracking");
                request.setSendError(new IllegalStateException("automatic message IDs exhausted"));
                return;
            }
        }
        try {
            if (this.exchangeStore.registerOutboundRequest(exchange)) {
                exchange.setRemoveHandler(this.exchangeRemoveHandler);
                LOGGER.debug("tracking open request [{}, {}]", (Object)exchange.getKeyMID(), (Object)exchange.getKeyToken());
            } else {
                LOGGER.debug("message IDs exhausted, could not register outbound request for tracking");
                request.setSendError(new IllegalStateException("automatic message IDs exhausted"));
            }
        }
        catch (IllegalArgumentException ex) {
            request.setSendError(ex);
        }
    }

    @Override
    public void sendResponse(Exchange exchange) {
        boolean ready = true;
        Response response = exchange.getCurrentResponse();
        response.ensureToken(exchange.getCurrentRequest().getToken());
        if (response.getType() == CoAP.Type.CON) {
            exchange.removeNotifications();
            if (this.exchangeStore.registerOutboundResponse(exchange)) {
                LOGGER.debug("tracking open response [{}]", (Object)exchange.getKeyMID());
                ready = false;
            } else {
                response.setSendError(new IllegalStateException("automatic message IDs exhausted"));
            }
        } else if (response.getType() == CoAP.Type.NON) {
            if (response.isNotification()) {
                if (this.exchangeStore.registerOutboundResponse(exchange)) {
                    ready = false;
                } else {
                    response.setSendError(new IllegalStateException("automatic message IDs exhausted"));
                }
            } else if (this.exchangeStore.assignMessageId(response) == -1) {
                response.setSendError(new IllegalStateException("automatic message IDs exhausted"));
            }
        }
        if (ready) {
            exchange.setComplete();
        }
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        message.setToken(Token.EMPTY);
        if (message.getType() == CoAP.Type.RST && exchange != null) {
            exchange.executeComplete();
        }
    }

    @Override
    public void receiveRequest(final Request request, final EndpointReceiver receiver) {
        boolean duplicate;
        Exchange exchange;
        Object peer = this.endpointContextMatcher.getEndpointIdentity(request.getSourceContext());
        KeyMID idByMID = new KeyMID(request.getMID(), peer);
        final Exchange previous = this.exchangeStore.findPrevious(idByMID, exchange = new Exchange(request, peer, Exchange.Origin.REMOTE, this.executor));
        boolean bl = duplicate = previous != null;
        if (duplicate) {
            InetSocketAddress previousGroup;
            InetSocketAddress group;
            EndpointContext sourceContext = request.getSourceContext();
            Request previousRequest = previous.getCurrentRequest();
            EndpointContext previousSourceContext = previous.isOfLocalOrigin() ? previousRequest.getDestinationContext() : previousRequest.getSourceContext();
            duplicate = this.endpointContextMatcher.isToBeSent(previousSourceContext, sourceContext);
            if (!duplicate) {
                if (this.exchangeStore.replacePrevious(idByMID, previous, exchange)) {
                    LOGGER.debug("replaced request {} by new request {}!", (Object)previousRequest, (Object)request);
                } else {
                    LOGGER.warn("new request {} could not be registered! Deduplication disabled!", (Object)request);
                }
            } else if ((previousRequest.isMulticast() || request.isMulticast()) && !NetworkInterfacesUtil.equals(group = request.getLocalAddress(), previousGroup = previousRequest.getLocalAddress())) {
                boolean differs = !Bytes.equals(request.getToken(), previousRequest.getToken());
                long timeDiff = TimeUnit.NANOSECONDS.toMillis(Math.abs(request.getNanoTimestamp() - previousRequest.getNanoTimestamp()));
                if (differs) {
                    LOGGER.info("received different requests {} with same MID via different multicast groups ({} != {}) within {}ms!", new Object[]{request, StringUtil.toLog(group), StringUtil.toLog(previousGroup), timeDiff});
                } else {
                    LOGGER.warn("received requests {} via different multicast groups ({} != {}) within {}ms!", new Object[]{request, StringUtil.toLog(group), StringUtil.toLog(previousGroup), timeDiff});
                }
            }
        }
        if (duplicate && previous != null) {
            LOGGER.trace("duplicate request: {}", (Object)request);
            request.setDuplicate(true);
            previous.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            receiver.receiveRequest(previous, request);
                        }
                        catch (RuntimeException ex) {
                            LOGGER.warn("error receiving again request {}", (Object)request, (Object)ex);
                            if (request.isMulticast()) break block2;
                            receiver.reject(request);
                        }
                    }
                }
            });
        } else {
            exchange.setRemoveHandler(this.exchangeRemoveHandler);
            exchange.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            receiver.receiveRequest(exchange, request);
                        }
                        catch (RuntimeException ex) {
                            LOGGER.warn("error receiving request {}", (Object)request, (Object)ex);
                            if (request.isMulticast()) break block2;
                            receiver.reject(request);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void receiveResponse(final Response response, final EndpointReceiver receiver) {
        final Object peer = this.endpointContextMatcher.getEndpointIdentity(response.getSourceContext());
        final KeyToken idByToken = this.tokenGenerator.getKeyToken(response.getToken(), peer);
        LOGGER.trace("received response {} from {}", (Object)response, (Object)response.getSourceContext());
        Exchange tempExchange = this.exchangeStore.get(idByToken);
        if (tempExchange == null) {
            KeyMID idByMID;
            Exchange prev;
            if (response.getType() != CoAP.Type.ACK && (prev = this.exchangeStore.find(idByMID = new KeyMID(response.getMID(), peer))) != null) {
                prev.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (prev.getCurrentRequest().isMulticast()) {
                            LOGGER.debug("Ignore delayed response {} to multicast request {}", (Object)response, StringUtil.toLog(prev.getCurrentRequest().getDestinationContext().getPeerAddress()));
                            UdpMatcher.this.cancel(response, receiver);
                            return;
                        }
                        try {
                            if (UdpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(prev.getEndpointContext(), response.getSourceContext())) {
                                LOGGER.trace("received response {} for already completed {}", (Object)response, (Object)prev);
                                response.setDuplicate(true);
                                Response prevResponse = prev.getCurrentResponse();
                                if (prevResponse != null) {
                                    response.setRejected(prevResponse.isRejected());
                                }
                                receiver.receiveResponse(prev, response);
                                return;
                            }
                            LOGGER.debug("ignoring potentially forged response {} for already completed {}", (Object)response, (Object)prev);
                        }
                        catch (RuntimeException ex) {
                            LOGGER.warn("error receiving response {} for {}", new Object[]{response, prev, ex});
                        }
                        UdpMatcher.this.reject(response, receiver);
                    }
                });
                return;
            }
            tempExchange = this.matchNotifyResponse(response);
            if (tempExchange == null) {
                if (response.getType() == CoAP.Type.ACK) {
                    LOGGER.trace("discarding by [{}] unmatchable piggy-backed response from [{}]: {}", new Object[]{idByToken, response.getSourceContext(), response});
                    this.cancel(response, receiver);
                } else {
                    LOGGER.trace("discarding by [{}] unmatchable response from [{}]: {}", new Object[]{idByToken, response.getSourceContext(), response});
                    this.reject(response, receiver);
                }
                return;
            }
        }
        final Exchange exchange = tempExchange;
        exchange.execute(new Runnable(){

            @Override
            public void run() {
                boolean checkResponseToken;
                boolean bl = checkResponseToken = !exchange.isNotification() || exchange.getRequest() != exchange.getCurrentRequest();
                if (checkResponseToken && UdpMatcher.this.exchangeStore.get(idByToken) != exchange) {
                    if (UdpMatcher.this.running) {
                        LOGGER.debug("ignoring response {}, exchange not longer matching!", (Object)response);
                    }
                    UdpMatcher.this.cancel(response, receiver);
                    return;
                }
                EndpointContext context = exchange.getEndpointContext();
                if (context == null) {
                    LOGGER.debug("ignoring response {}, request pending to sent!", (Object)response);
                    UdpMatcher.this.cancel(response, receiver);
                    return;
                }
                try {
                    if (UdpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(context, response.getSourceContext())) {
                        KeyMID idByMID;
                        Exchange prev;
                        CoAP.Type type = response.getType();
                        Request currentRequest = exchange.getCurrentRequest();
                        int requestMid = currentRequest.getMID();
                        if (currentRequest.isMulticast()) {
                            if (type != CoAP.Type.NON) {
                                LOGGER.debug("ignoring response of type {} for multicast request with token [{}], from {}", new Object[]{response.getType(), response.getTokenString(), StringUtil.toLog(response.getSourceContext().getPeerAddress())});
                                UdpMatcher.this.cancel(response, receiver);
                                return;
                            }
                        } else if (type == CoAP.Type.ACK && requestMid != response.getMID()) {
                            LOGGER.debug("ignoring ACK, possible MID reuse before lifetime end for token {}, expected MID {} but received {}", new Object[]{response.getTokenString(), requestMid, response.getMID()});
                            UdpMatcher.this.cancel(response, receiver);
                            return;
                        }
                        if (type != CoAP.Type.ACK && !exchange.isNotification() && response.isNotification() && currentRequest.isObserveCancel()) {
                            LOGGER.debug("ignoring notify for pending cancel {}!", (Object)response);
                            UdpMatcher.this.cancel(response, receiver);
                            return;
                        }
                        if ((type == CoAP.Type.CON || type == CoAP.Type.NON) && (prev = UdpMatcher.this.exchangeStore.findPrevious(idByMID = new KeyMID(response.getMID(), peer), exchange)) != null) {
                            LOGGER.trace("received duplicate response for open {}: {}", (Object)exchange, (Object)response);
                            response.setDuplicate(true);
                            Response prevResponse = prev.getCurrentResponse();
                            if (prevResponse != null) {
                                response.setRejected(prevResponse.isRejected());
                            }
                        }
                        receiver.receiveResponse(exchange, response);
                        return;
                    }
                    LOGGER.debug("ignoring potentially forged response for token {} with non-matching endpoint context", (Object)idByToken);
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("error receiving response {} for {}", new Object[]{response, exchange, ex});
                }
                UdpMatcher.this.reject(response, receiver);
            }
        });
    }

    @Override
    public void receiveEmptyMessage(final EmptyMessage message, final EndpointReceiver receiver) {
        KeyMID pongByMID;
        EndpointContext context = message.getSourceContext();
        Object identity = this.endpointContextMatcher.getEndpointIdentity(context);
        KeyMID byMID = new KeyMID(message.getMID(), identity);
        Exchange tempExchange = this.exchangeStore.get(byMID);
        if (tempExchange == null && identity != context.getPeerAddress() && (tempExchange = this.exchangeStore.get(pongByMID = new KeyMID(message.getMID(), context.getPeerAddress()))) != null) {
            byMID = pongByMID;
        }
        if (tempExchange == null) {
            LOGGER.debug("ignoring {} message unmatchable by {}", (Object)message.getType(), (Object)byMID);
            this.cancel(message, receiver);
            return;
        }
        final KeyMID idByMID = byMID;
        final Exchange exchange = tempExchange;
        exchange.execute(new Runnable(){

            @Override
            public void run() {
                if (exchange.getCurrentRequest().isMulticast()) {
                    LOGGER.debug("ignoring {} message for multicast request {}", (Object)message.getType(), (Object)idByMID);
                    UdpMatcher.this.cancel(message, receiver);
                    return;
                }
                if (UdpMatcher.this.exchangeStore.get(idByMID) != exchange) {
                    if (UdpMatcher.this.running) {
                        LOGGER.debug("ignoring {} message not longer matching by {}", (Object)message.getType(), (Object)idByMID);
                    }
                    UdpMatcher.this.cancel(message, receiver);
                    return;
                }
                try {
                    if (UdpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(exchange.getEndpointContext(), message.getSourceContext())) {
                        UdpMatcher.this.exchangeStore.remove(idByMID, exchange);
                        LOGGER.debug("received expected {} reply for {}", (Object)message.getType(), (Object)idByMID);
                        receiver.receiveEmptyMessage(exchange, message);
                        return;
                    }
                    LOGGER.debug("ignoring potentially forged {} reply for {} with non-matching endpoint context", (Object)message.getType(), (Object)idByMID);
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("error receiving {} message for {}", new Object[]{message.getType(), exchange, ex});
                }
                UdpMatcher.this.cancel(message, receiver);
            }
        });
    }

    private void reject(Response response, EndpointReceiver receiver) {
        if (response.getType() != CoAP.Type.ACK && response.hasMID()) {
            receiver.reject(response);
        }
        this.cancel(response, receiver);
    }

    private void cancel(Response response, EndpointReceiver receiver) {
        response.setCanceled(true);
        receiver.receiveResponse(null, response);
    }

    private void cancel(EmptyMessage message, EndpointReceiver receiver) {
        message.setCanceled(true);
        receiver.receiveEmptyMessage(null, message);
    }

    private class RemoveHandlerImpl
    implements RemoveHandler {
        private RemoveHandlerImpl() {
        }

        @Override
        public void remove(Exchange exchange, KeyToken keyToken, KeyMID keyMID) {
            if (keyToken != null) {
                UdpMatcher.this.exchangeStore.remove(keyToken, exchange);
            }
            if (keyMID != null) {
                UdpMatcher.this.exchangeStore.remove(keyMID, exchange);
            }
        }
    }
}

