/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.interceptors;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.interceptors.MessageInterceptorAdapter;
import org.eclipse.californium.elements.util.LeastRecentlyUpdatedCache;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnonymizedOriginTracer
extends MessageInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnonymizedOriginTracer.class);
    private static final int ID_LENGTH = 6;
    private static final int INITIAL_CAPACITY = 1000;
    private static final int MAX_CAPACITY = 10000;
    private static final long DEFAULT_MESSAGE_FILTER_TIMEOUT_IN_SECONDS = 60L;
    private static final long HOST_TIMEOUT_IN_SECONDS = 86400L;
    private static final LeastRecentlyUpdatedCache<InetAddress, String> CLIENT_CACHE = new LeastRecentlyUpdatedCache(1000, 10000, 86400L, TimeUnit.SECONDS);
    private static final Mac HMAC;
    private static final SecretKeySpec KEY;
    private final LeastRecentlyUpdatedCache<InetSocketAddress, String> currentTests = new LeastRecentlyUpdatedCache(1000, 10000, 60L, TimeUnit.SECONDS);
    private final String scheme;

    public AnonymizedOriginTracer(String scheme) {
        this(scheme, 60L);
    }

    public AnonymizedOriginTracer(String scheme, long filterTimeout) {
        this.scheme = scheme;
        this.currentTests.setExpirationThreshold(filterTimeout, TimeUnit.SECONDS);
        this.currentTests.setHideStaleValues(true);
    }

    @Override
    public void receiveRequest(Request request) {
        this.log(request);
    }

    @Override
    public void receiveEmptyMessage(EmptyMessage message) {
        if (message.getType() == CoAP.Type.CON) {
            this.log(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean log(Message message) {
        InetSocketAddress address;
        block7: {
            address = message.getSourceContext().getPeerAddress();
            this.currentTests.removeExpiredEntries(32);
            ReentrantReadWriteLock.WriteLock lock = this.currentTests.writeLock();
            lock.lock();
            try {
                if (this.currentTests.update(address) == null) {
                    this.currentTests.put(address, this.scheme);
                    break block7;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        String id = AnonymizedOriginTracer.getAnonymizedOrigin(address.getAddress());
        if (id != null) {
            if (this.scheme == null) {
                LOGGER.trace("{}:{}", (Object)id, (Object)address.getPort());
            } else {
                LOGGER.trace("{}://{}:{}", new Object[]{this.scheme, id, address.getPort()});
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAnonymizedOrigin(InetAddress address) {
        CLIENT_CACHE.removeExpiredEntries(32);
        ReentrantReadWriteLock.WriteLock lock = CLIENT_CACHE.writeLock();
        lock.lock();
        try {
            String id = CLIENT_CACHE.update(address);
            if (id == null) {
                byte[] raw = (byte[])address.getAddress().clone();
                try {
                    if (HMAC == null) {
                        byte[] mask = KEY.getEncoded();
                        for (int index = 0; index < raw.length; ++index) {
                            int n = index;
                            raw[n] = (byte)(raw[n] ^ mask[index]);
                        }
                    } else {
                        HMAC.init(KEY);
                        raw = HMAC.doFinal(raw);
                    }
                }
                catch (InvalidKeyException invalidKeyException) {
                    // empty catch block
                }
                id = StringUtil.byteArray2HexString(raw, '\u0000', 6);
                CLIENT_CACHE.put(address, id);
            }
            String string = id;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    static {
        SecureRandom rng = new SecureRandom();
        byte[] rd = new byte[32];
        rng.nextBytes(rd);
        KEY = new SecretKeySpec(rd, "MAC");
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        HMAC = mac;
        CLIENT_CACHE.setHideStaleValues(true);
    }
}

