/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.observe.ObserveHealth;
import org.eclipse.californium.core.observe.ObserveManager;
import org.eclipse.californium.core.server.DelivererException;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.core.server.resources.ObservableResource;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMessageDeliverer
implements MessageDeliverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerMessageDeliverer.class);
    private final Resource root;
    private final ObserveManager observeManager;

    @Deprecated
    public ServerMessageDeliverer(Resource root) {
        this(root, null);
    }

    public ServerMessageDeliverer(Resource root, Configuration config) {
        this.root = root;
        this.observeManager = new ObserveManager(config);
    }

    public void setObserveHealth(ObserveHealth observeHealth) {
        this.observeManager.setObserveHealth(observeHealth);
    }

    @Override
    public final void deliverRequest(final Exchange exchange) {
        if (exchange == null) {
            throw new NullPointerException("exchange must not be null");
        }
        boolean processed = this.preDeliverRequest(exchange);
        if (!processed) {
            try {
                final Resource resource = this.findResource(exchange);
                if (resource != null) {
                    this.checkForObserveOption(exchange, resource);
                    Executor executor = resource.getExecutor();
                    if (executor != null) {
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                resource.handleRequest(exchange);
                            }
                        });
                    } else {
                        resource.handleRequest(exchange);
                    }
                } else {
                    if (LOGGER.isInfoEnabled()) {
                        Request request = exchange.getRequest();
                        LOGGER.info("did not find resource /{} requested by {}", (Object)request.getOptions().getUriPathString(), StringUtil.toLog(request.getSourceContext().getPeerAddress()));
                    }
                    exchange.sendResponse(new Response(CoAP.ResponseCode.NOT_FOUND, true));
                }
            }
            catch (DelivererException ex) {
                Response response = new Response(ex.getErrorResponseCode(), ex.isInternal());
                response.setPayload(ex.getMessage());
                exchange.sendResponse(response);
            }
        }
    }

    protected boolean preDeliverRequest(Exchange exchange) {
        return false;
    }

    protected final void checkForObserveOption(Exchange exchange, Resource resource) {
        Request request = exchange.getRequest();
        if (CoAP.isObservable(request.getCode()) && request.getOptions().hasObserve() && resource.isObservable() && resource instanceof ObservableResource) {
            if (request.isObserve()) {
                InetSocketAddress source = request.getSourceContext().getPeerAddress();
                LOGGER.debug("initiating an observe relation between {} and resource {}, {}", new Object[]{StringUtil.toLog(source), resource.getURI(), exchange});
                this.observeManager.addObserveRelation(exchange, (ObservableResource)((Object)resource));
                request.setProtectFromOffload();
            } else if (request.isObserveCancel()) {
                InetSocketAddress source = request.getSourceContext().getPeerAddress();
                LOGGER.debug("cancel an observe relation between {} and resource {}, {}", new Object[]{StringUtil.toLog(source), resource.getURI(), exchange});
                this.observeManager.cancelObserveRelation(exchange);
            }
        }
    }

    protected Resource getRootResource() {
        return this.root;
    }

    protected Resource findResource(Exchange exchange) throws DelivererException {
        return this.findResource(exchange.getRequest().getOptions().getUriPath());
    }

    protected Resource findResource(List<String> path) throws DelivererException {
        String name;
        Resource current = this.getRootResource();
        Iterator<String> iterator = path.iterator();
        while (iterator.hasNext() && (current = current.getChild(name = iterator.next())) != null) {
        }
        return current;
    }

    @Override
    public final void deliverResponse(Exchange exchange, Response response) {
        if (response == null) {
            throw new NullPointerException("Response must not be null");
        }
        if (exchange == null) {
            throw new NullPointerException("Exchange must not be null");
        }
        if (exchange.getRequest() == null) {
            throw new IllegalArgumentException("Exchange does not contain request");
        }
        boolean processed = this.preDeliverResponse(exchange, response);
        if (!processed) {
            exchange.getRequest().setResponse(response);
        }
    }

    protected boolean preDeliverResponse(Exchange exchange, Response response) {
        return false;
    }
}

