/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.PersistentConnector;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.PersistentComponentUtil;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ServersSerializationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServersSerializationUtil.class);
    private List<CoapServer> servers = new CopyOnWriteArrayList<CoapServer>();
    private boolean useDeprecatedSerialization;
    protected PersistentComponentUtil persistentUtil = new PersistentComponentUtil();

    public ServersSerializationUtil() {
        this(false);
    }

    protected ServersSerializationUtil(boolean useDeprecatedSerialization) {
        this.useDeprecatedSerialization = useDeprecatedSerialization;
    }

    public void add(CoapServer server) {
        this.servers.add(server);
        this.persistentUtil.addProvider(server);
    }

    private boolean updateUtil() {
        this.persistentUtil.updateProvidersComponents();
        return !this.persistentUtil.isEmpty();
    }

    public void loadServers(InputStream in) {
        int count = -1;
        if (this.updateUtil()) {
            count = this.persistentUtil.loadComponents(in);
        }
        if (count < 0) {
            ServersSerializationUtil.loadServers(in, this.servers);
        }
    }

    public void saveServers(OutputStream out, long maxQuietPeriodInSeconds) throws IOException {
        if (this.useDeprecatedSerialization || !this.updateUtil()) {
            ServersSerializationUtil.saveServers(out, maxQuietPeriodInSeconds, this.servers);
        } else {
            for (CoapServer server : this.servers) {
                server.stop();
            }
            this.persistentUtil.saveComponents(out, maxQuietPeriodInSeconds);
        }
    }

    public void start() {
        for (CoapServer server : this.servers) {
            server.start();
        }
    }

    public void stop() {
        for (CoapServer server : this.servers) {
            server.stop();
        }
    }

    public void destroy() {
        for (CoapServer server : this.servers) {
            server.destroy();
        }
    }

    public static int loadServers(InputStream in, CoapServer ... servers) {
        return ServersSerializationUtil.loadServers(in, Arrays.asList(servers));
    }

    public static int loadServers(InputStream in, List<CoapServer> servers) {
        int count = 0;
        long time = System.nanoTime();
        ArrayList<CoapServer.ConnectorIdentifier> failed = new ArrayList<CoapServer.ConnectorIdentifier>();
        try {
            CoapServer.ConnectorIdentifier id;
            DataStreamReader reader = new DataStreamReader(in);
            long delta = SerializationUtil.readNanotimeSynchronizationMark(reader);
            while ((id = CoapServer.readConnectorIdentifier(in)) != null) {
                boolean foundTag = false;
                int loaded = -1;
                for (CoapServer server : servers) {
                    if (!id.tag.equals(server.getTag())) continue;
                    foundTag = true;
                    loaded = server.loadConnector(id, in, delta);
                    if (loaded < 0) continue;
                    count += loaded;
                    break;
                }
                if (foundTag) {
                    if (loaded < 0) {
                        int skip = SerializationUtil.skipItems(new DataStreamReader(in), 16);
                        LOGGER.warn("{}loading {} failed, {} connections skipped, no connector in {} servers!", new Object[]{id.tag, id.uri, skip, servers.size()});
                        failed.add(id);
                        continue;
                    }
                    LOGGER.info("{}loading {}, {} connections, {} servers.", new Object[]{id.tag, id.uri, loaded, servers.size()});
                    continue;
                }
                int skip = SerializationUtil.skipItems(new DataStreamReader(in), 16);
                LOGGER.warn("{}loading {} failed, {} connections skipped, no server in {} servers!", new Object[]{id.tag, id.uri, skip, servers.size()});
                failed.add(id);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("loading failed:", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("loading failed:", (Throwable)e);
        }
        if (!failed.isEmpty()) {
            LOGGER.warn("Loading failures:");
            for (int index = 0; index < failed.size(); ++index) {
                LOGGER.warn("[CON {}] {}", (Object)index, failed.get(index));
            }
            int index2 = 0;
            for (CoapServer server : servers) {
                List<Endpoint> endpoints = server.getEndpoints();
                for (Endpoint endpoint : endpoints) {
                    Connector connector;
                    if (!(endpoint instanceof CoapEndpoint) || !((connector = ((CoapEndpoint)endpoint).getConnector()) instanceof PersistentConnector)) continue;
                    LOGGER.warn("[SRV {}] {}{}", new Object[]{index2, server.getTag(), endpoint.getUri().toASCIIString()});
                    ++index2;
                }
            }
        }
        time = System.nanoTime() - time;
        LOGGER.info("load: {} ms, {} connections", (Object)TimeUnit.NANOSECONDS.toMillis(time), (Object)count);
        return count;
    }

    public static int saveServers(OutputStream out, long maxQuietPeriodInSeconds, CoapServer ... servers) throws IOException {
        return ServersSerializationUtil.saveServers(out, maxQuietPeriodInSeconds, Arrays.asList(servers));
    }

    public static int saveServers(OutputStream out, long maxQuietPeriodInSeconds, List<CoapServer> servers) throws IOException {
        int count = 0;
        for (CoapServer server : servers) {
            server.stop();
        }
        long start = System.nanoTime();
        DatagramWriter writer = new DatagramWriter();
        SerializationUtil.writeNanotimeSynchronizationMark(writer);
        writer.writeTo(out);
        for (CoapServer server : servers) {
            count += server.saveAllConnectors(out, maxQuietPeriodInSeconds);
        }
        SerializationUtil.write(writer, null, 8);
        writer.writeTo(out);
        long time = System.nanoTime() - start;
        LOGGER.info("save: {} ms, {} connections", (Object)TimeUnit.NANOSECONDS.toMillis(time), (Object)count);
        return count;
    }
}

