/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server.resources;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.util.StringUtil;

public class MyIpResource
extends CoapResource {
    public static final String RESOURCE_NAME = "myip";

    public MyIpResource(String name, boolean visible) {
        super(name, visible);
        this.getAttributes().setTitle("MyIP");
        this.getAttributes().addContentType(0);
        this.getAttributes().addContentType(50);
        this.getAttributes().addContentType(41);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        int accept = request.getOptions().getAccept();
        if (accept == -1) {
            accept = 0;
        }
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        response.getOptions().setContentFormat(accept);
        byte[] payload = null;
        switch (accept) {
            case 0: {
                payload = this.handleGetFormat(exchange, "%1$s");
                break;
            }
            case 50: {
                payload = this.handleGetFormat(exchange, "{ \"ip\" : \"%2$s\",\n \"port\" : %3$d }");
                break;
            }
            case 41: {
                payload = this.handleGetFormat(exchange, "<ip host=\"%2$s\" port=\"%3$d\" />");
                break;
            }
            default: {
                String ct = MediaTypeRegistry.toString(accept);
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE, "Type \"" + ct + "\" is not supported for this resource!", 0);
                return;
            }
        }
        response.setPayload(payload);
        exchange.respond(response);
    }

    private byte[] handleGetFormat(CoapExchange exchange, String format) {
        InetSocketAddress source = exchange.advanced().getRequest().getSourceContext().getPeerAddress();
        String address = StringUtil.toString(source);
        String host = StringUtil.toString(source.getAddress());
        return String.format(format, address, host, source.getPort()).getBytes();
    }
}

