/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.List;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateVerify
extends HandshakeMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateVerify.class);
    private static final int HASH_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_LENGTH_BITS = 16;
    private final byte[] signatureBytes;
    private final SignatureAndHashAlgorithm signatureAndHashAlgorithm;

    public CertificateVerify(SignatureAndHashAlgorithm signatureAndHashAlgorithm, PrivateKey clientPrivateKey, List<HandshakeMessage> handshakeMessages) {
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        this.signatureBytes = CertificateVerify.sign(signatureAndHashAlgorithm, clientPrivateKey, handshakeMessages);
    }

    private CertificateVerify(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] signatureBytes) {
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        this.signatureBytes = signatureBytes;
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.CERTIFICATE_VERIFY;
    }

    @Override
    public int getMessageLength() {
        return 4 + this.signatureBytes.length;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter(this.signatureBytes.length + 4);
        writer.write(this.signatureAndHashAlgorithm.getHash().getCode(), 8);
        writer.write(this.signatureAndHashAlgorithm.getSignature().getCode(), 8);
        writer.writeVarBytes(this.signatureBytes, 16);
        return writer.toByteArray();
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        sb.append(indentation).append("Signature: ");
        sb.append(this.signatureAndHashAlgorithm).append("-").append(StringUtil.byteArray2HexString(this.signatureBytes, '\u0000', 16));
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }

    public static HandshakeMessage fromReader(DatagramReader reader) {
        int hashAlgorithm = reader.read(8);
        int signatureAlgorithm = reader.read(8);
        SignatureAndHashAlgorithm signAndHash = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
        byte[] signature = reader.readVarBytes(16);
        return new CertificateVerify(signAndHash, signature);
    }

    private static byte[] sign(SignatureAndHashAlgorithm signatureAndHashAlgorithm, PrivateKey clientPrivateKey, List<HandshakeMessage> handshakeMessages) {
        byte[] signatureBytes = Bytes.EMPTY;
        try {
            ThreadLocalSignature localSignature = signatureAndHashAlgorithm.getThreadLocalSignature();
            Signature signature = (Signature)localSignature.currentWithCause();
            signature.initSign(clientPrivateKey, RandomManager.currentSecureRandom());
            int index = 0;
            for (HandshakeMessage message : handshakeMessages) {
                signature.update(message.toByteArray());
                LOGGER.trace("  [{}] - {}", (Object)index, (Object)message.getMessageType());
                ++index;
            }
            signatureBytes = signature.sign();
        }
        catch (Exception e) {
            LOGGER.error("Could not create signature.", (Throwable)e);
        }
        return signatureBytes;
    }

    public void verifySignature(PublicKey clientPublicKey, List<HandshakeMessage> handshakeMessages) throws HandshakeException {
        try {
            ThreadLocalSignature localSignature = this.signatureAndHashAlgorithm.getThreadLocalSignature();
            Signature signature = (Signature)localSignature.currentWithCause();
            signature.initVerify(clientPublicKey);
            int index = 0;
            for (HandshakeMessage message : handshakeMessages) {
                signature.update(message.toByteArray());
                LOGGER.trace("  [{}] - {}", (Object)index, (Object)message.getMessageType());
                ++index;
            }
            if (signature.verify(this.signatureBytes)) {
                if (JceProviderUtil.isEcdsaVulnerable() && this.signatureAndHashAlgorithm.getSignature() == SignatureAndHashAlgorithm.SignatureAlgorithm.ECDSA) {
                    Asn1DerDecoder.checkEcDsaSignature(this.signatureBytes, clientPublicKey);
                }
                return;
            }
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not verify the client's signature.", (Throwable)e);
        }
        String message = "The client's CertificateVerify message could not be verified.";
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECRYPT_ERROR);
        throw new HandshakeException(message, alert);
    }
}

