/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ResourceSupport;

public class CachedResource
extends ResourceSupport {
    private final Resource delegate;
    private byte[] data;

    public CachedResource(Resource delegate) {
        super("cached:" + delegate.getScheme(), delegate.getLocation());
        this.delegate = delegate;
    }

    @Override
    public boolean exists() {
        return this.delegate.exists();
    }

    @Override
    public URI getURI() {
        return this.delegate.getURI();
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return this.delegate.getURL();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            try (InputStream is = this.delegate.getInputStream();){
                this.data = is.readAllBytes();
            }
        }
        return new ByteArrayInputStream(this.data);
    }
}

