/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http.jakarta;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.HttpException;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.http.AbstractHttpTransport;
import org.cometd.server.http.jakarta.JakartaBayeuxContext;
import org.cometd.server.http.jakarta.JakartaCometDRequest;
import org.cometd.server.http.jakarta.JakartaCometDResponse;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometDServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(CometDServlet.class);
    private BayeuxServer bayeuxServer;
    private boolean exported;

    @Override
    public void init() throws ServletException {
        String bayeuxServerContextAttributeName = this.getBayeuxServerContextAttributeName();
        this.bayeuxServer = (BayeuxServer)this.getServletContext().getAttribute(bayeuxServerContextAttributeName);
        if (this.bayeuxServer == null) {
            this.bayeuxServer = this.newBayeuxServer();
            this.exported = true;
            for (String initParamName : Collections.list(this.getInitParameterNames())) {
                this.bayeuxServer.setOption(initParamName, this.getInitParameter(initParamName));
            }
        }
        this.bayeuxServer.setOption(ServletContext.class.getName(), this.getServletContext());
        LifeCycle.start(this.bayeuxServer);
        if (this.exported) {
            this.getServletContext().setAttribute(bayeuxServerContextAttributeName, this.bayeuxServer);
        }
    }

    public BayeuxServer getBayeuxServer() {
        return this.bayeuxServer;
    }

    protected BayeuxServer newBayeuxServer() {
        return new BayeuxServerImpl();
    }

    @Override
    protected void service(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        if ("OPTIONS".equals(request.getMethod())) {
            this.serviceOptions(request, response);
            return;
        }
        final AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        JakartaCometDRequest cometDRequest = new JakartaCometDRequest(request);
        JakartaCometDResponse cometDResponse = new JakartaCometDResponse(response);
        JakartaBayeuxContext bayeuxContext = new JakartaBayeuxContext(request);
        Promise<Void> promise = new Promise<Void>(this){
            final /* synthetic */ CometDServlet this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void succeed(Void result) {
                asyncContext.complete();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Handling successful");
                }
            }

            @Override
            public void fail(Throwable failure) {
                int code = 500;
                Throwable cause = failure;
                if (failure instanceof HttpException) {
                    HttpException http = (HttpException)failure;
                    code = http.getCode();
                    cause = http.getCause();
                }
                this.this$0.sendError(request, response, code, cause);
                asyncContext.complete();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Handling failed", failure);
                }
            }
        };
        AbstractHttpTransport transport = AbstractHttpTransport.find(this.bayeuxServer, cometDRequest);
        if (transport == null) {
            response.sendError(400, "Unknown Bayeux Transport");
        } else {
            transport.handle(bayeuxContext, cometDRequest, cometDResponse, promise);
        }
    }

    protected void serviceOptions(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void sendError(HttpServletRequest request, HttpServletResponse response, int code, Throwable failure) {
        block2: {
            try {
                request.setAttribute("jakarta.servlet.error.exception", failure);
                response.sendError(code);
            }
            catch (Throwable x) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("", x);
            }
        }
    }

    @Override
    public void destroy() {
        for (ServerSession session : this.bayeuxServer.getSessions()) {
            ((ServerSessionImpl)session).destroyScheduler();
        }
        try {
            LifeCycle.stop(this.bayeuxServer);
        }
        catch (Exception x) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("", (Throwable)x);
            }
        }
        finally {
            this.bayeuxServer = null;
            if (this.exported) {
                this.getServletContext().removeAttribute(this.getBayeuxServerContextAttributeName());
            }
        }
    }

    private String getBayeuxServerContextAttributeName() {
        String name = this.getServletConfig().getInitParameter("bayeuxServerContextAttributeName");
        return name != null ? name : "org.cometd.bayeux";
    }
}

