/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import org.apache.camel.Exchange;
import org.apache.camel.component.cometd.CometdBinding;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.support.DefaultProducer;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractService;
import org.cometd.server.BayeuxServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometdProducer
extends DefaultProducer
implements CometdProducerConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CometdProducer.class);
    private BayeuxServerImpl bayeux;
    private ProducerService service;
    private final CometdEndpoint endpoint;

    public CometdProducer(CometdEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.endpoint.connect(this);
        if (this.service == null) {
            this.service = new ProducerService(this.getBayeux(), new CometdBinding(this.bayeux), this.endpoint.getPath(), this, this.getEndpoint().isDisconnectLocalSession());
        }
    }

    @Override
    public void doStop() throws Exception {
        super.stop();
        this.endpoint.disconnect(this);
    }

    @Override
    public void process(Exchange exchange) {
        this.service.process(exchange);
    }

    @Override
    public CometdEndpoint getEndpoint() {
        return this.endpoint;
    }

    public BayeuxServerImpl getBayeux() {
        return this.bayeux;
    }

    protected ProducerService getProducerService() {
        return this.service;
    }

    @Override
    public void setBayeux(BayeuxServerImpl bayeux) {
        this.bayeux = bayeux;
    }

    public static class ProducerService
    extends AbstractService {
        private final CometdProducer producer;
        private final CometdBinding binding;
        private final boolean disconnectLocalSession;

        public ProducerService(BayeuxServer bayeux, CometdBinding cometdBinding, String channel, CometdProducer producer, boolean disconnectLocalSession) {
            super(bayeux, channel);
            this.producer = producer;
            this.binding = cometdBinding;
            this.disconnectLocalSession = disconnectLocalSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Exchange exchange) {
            String channelName = this.producer.getEndpoint().getPath();
            BayeuxServerImpl bayeux = this.producer.getBayeux();
            ServerChannel channel = bayeux.getChannel(channelName);
            ServerSession serverSession = this.getServerSession();
            try {
                if (channel != null) {
                    this.logDelivery(exchange, channel);
                    ServerMessage.Mutable mutable = this.binding.createCometdMessage(channel, serverSession, exchange.getIn());
                    channel.publish((Session)serverSession, mutable, new Promise<Boolean>(){});
                }
            }
            finally {
                if (this.disconnectLocalSession && serverSession.isLocalSession()) {
                    LOG.trace("Disconnection local session {}", (Object)serverSession);
                    serverSession.disconnect();
                }
            }
        }

        private void logDelivery(Exchange exchange, ServerChannel channel) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Delivering to clients %s path: %s exchange: %s", channel.getSubscribers(), channel, exchange));
            }
        }
    }
}

