/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.List;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.common.JSONContext;
import org.cometd.common.JettyJSONContext;
import org.cometd.server.JSONContextServer;
import org.cometd.server.ServerMessageImpl;
import org.eclipse.jetty.util.ajax.AsyncJSON;

public class JettyJSONContextServer
extends JettyJSONContext<ServerMessage.Mutable>
implements JSONContextServer {
    @Override
    protected ServerMessage.Mutable newMessage() {
        return new ServerMessageImpl();
    }

    @Override
    public JSONContext.AsyncParser newAsyncParser() {
        AsyncJSON asyncJSON = this.getAsyncJSONFactory().newAsyncJSON();
        return new JettyJSONContext.AsyncJSONParser(asyncJSON){

            @Override
            public <R> R complete() {
                Object object = super.complete();
                if (object == null) {
                    return null;
                }
                if (object instanceof List) {
                    return object;
                }
                if (object.getClass().isArray()) {
                    return (R)List.of((ServerMessage.Mutable[])object);
                }
                return (R)List.of((ServerMessage.Mutable)object);
            }
        };
    }

    @Override
    public String generate(ServerMessage.Mutable message) {
        String json = JSONContextServer.super.generate(message);
        if (json == null) {
            json = super.generate(message);
        }
        return json;
    }

    @Override
    public JSONContext.Generator getGenerator() {
        return new JSONGeneratorServer();
    }

    private class JSONGeneratorServer
    extends JettyJSONContext.JSONGenerator {
        private JSONGeneratorServer() {
        }

        @Override
        public String generate(Object object) {
            String json = null;
            if (object instanceof ServerMessageImpl) {
                json = ((ServerMessageImpl)object).getJSON();
            }
            if (json == null) {
                json = super.generate(object);
            }
            return json;
        }
    }
}

