/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletMultiPartFormData;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;

public class EagerFormHandler
extends Handler.Wrapper {
    public EagerFormHandler() {
        this((Handler)null);
    }

    public EagerFormHandler(Handler handler) {
        super(handler);
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        CompletableFuture<Fields> future;
        String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (contentType == null) {
            return super.handle(request, response, callback);
        }
        MimeTypes.Type mimeType = MimeTypes.getBaseType(contentType);
        if (mimeType == null) {
            return super.handle(request, response, callback);
        }
        switch (mimeType) {
            case FORM_ENCODED: {
                CompletableFuture<Object> completableFuture = FormFields.from(request);
                break;
            }
            case MULTIPART_FORM_DATA: {
                CompletableFuture<Object> completableFuture = ServletMultiPartFormData.from(Request.as(request, ServletContextRequest.class).getServletApiRequest(), contentType);
                break;
            }
            default: {
                CompletableFuture<Object> completableFuture = future = null;
            }
        }
        if (future == null) {
            return super.handle(request, response, callback);
        }
        future.whenComplete((result, failure) -> {
            try {
                if (!super.handle(request, response, callback)) {
                    callback.failed(new IllegalStateException("Not Handled"));
                }
            }
            catch (Throwable x) {
                callback.failed(x);
            }
        });
        return true;
    }
}

