/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.concurrent.NamedThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed ReactiveExecutor")
public class DefaultReactiveExecutor
extends ServiceSupport
implements ReactiveExecutor,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReactiveExecutor.class);
    private boolean statisticsEnabled;
    private final AtomicInteger createdWorkers = new AtomicInteger();
    private final LongAdder runningWorkers = new LongAdder();
    private final LongAdder pendingTasks = new LongAdder();
    private final NamedThreadLocal<Worker> workers = new NamedThreadLocal<Worker>("CamelReactiveWorker", () -> {
        int number = this.createdWorkers.incrementAndGet();
        return new Worker(number, this);
    });

    @Override
    public void schedule(Runnable runnable2) {
        ((Worker)this.workers.get()).schedule(runnable2, false, false, false);
    }

    @Override
    public void scheduleMain(Runnable runnable2) {
        ((Worker)this.workers.get()).schedule(runnable2, true, true, false);
    }

    @Override
    public void scheduleSync(Runnable runnable2) {
        ((Worker)this.workers.get()).schedule(runnable2, false, true, true);
    }

    @Override
    public void scheduleQueue(Runnable runnable2) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("ScheduleQueue: {}", (Object)runnable2);
        }
        ((Worker)this.workers.get()).queue.add(runnable2);
    }

    @Override
    public boolean executeFromQueue() {
        return ((Worker)this.workers.get()).executeFromQueue();
    }

    @Override
    @ManagedAttribute(description="Whether statistics is enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="Number of created workers")
    public int getCreatedWorkers() {
        return this.createdWorkers.get();
    }

    @ManagedAttribute(description="Number of running workers")
    public int getRunningWorkers() {
        return this.runningWorkers.intValue();
    }

    @ManagedAttribute(description="Number of pending tasks")
    public int getPendingTasks() {
        return this.pendingTasks.intValue();
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled() && this.statisticsEnabled) {
            LOG.debug("Stopping DefaultReactiveExecutor [createdWorkers: {}, runningWorkers: {}, pendingTasks: {}]", new Object[]{this.getCreatedWorkers(), this.getRunningWorkers(), this.getPendingTasks()});
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        this.workers.remove();
    }

    private static class Worker {
        private final int number;
        private final DefaultReactiveExecutor executor;
        private final boolean stats;
        private volatile Deque<Runnable> queue = new ArrayDeque<Runnable>();
        private volatile Deque<Deque<Runnable>> back;
        private volatile boolean running;

        public Worker(int number, DefaultReactiveExecutor executor) {
            this.number = number;
            this.executor = executor;
            this.stats = executor != null && executor.isStatisticsEnabled();
        }

        void schedule(Runnable runnable2, boolean first, boolean main, boolean sync) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Schedule [first={}, main={}, sync={}]: {}", new Object[]{first, main, sync, runnable2});
            }
            if (main) {
                this.executeMainFlow();
            }
            if (first) {
                this.queue.addFirst(runnable2);
            } else {
                this.queue.addLast(runnable2);
            }
            this.incrementPendingTasks();
            this.tryExecuteReactiveWork(runnable2, sync);
        }

        private void executeMainFlow() {
            if (!this.queue.isEmpty()) {
                if (this.back == null) {
                    this.back = new ArrayDeque<Deque<Runnable>>();
                }
                this.back.push(this.queue);
                this.queue = new ArrayDeque<Runnable>();
            }
        }

        private void tryExecuteReactiveWork(Runnable runnable2, boolean sync) {
            if (!this.running || sync) {
                this.running = true;
                this.incrementRunningWorkers();
                try {
                    this.executeReactiveWork();
                }
                finally {
                    this.running = false;
                    this.decrementRunningWorkers();
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Queuing reactive work: {}", (Object)runnable2);
            }
        }

        private void executeReactiveWork() {
            while (true) {
                Runnable polled;
                if ((polled = this.queue.pollFirst()) == null) {
                    if (this.back == null || this.back.isEmpty()) break;
                    this.queue = this.back.pollFirst();
                    continue;
                }
                this.doRun(polled);
            }
        }

        private void doRun(Runnable polled) {
            try {
                this.decrementPendingTasks();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Worker #{} running: {}", (Object)this.number, (Object)polled);
                }
                polled.run();
            }
            catch (Exception t2) {
                LOG.warn("Error executing reactive work due to {}. This exception is ignored.", (Object)t2.getMessage(), (Object)t2);
            }
        }

        private void decrementRunningWorkers() {
            if (this.stats) {
                this.executor.runningWorkers.decrement();
            }
        }

        private void incrementRunningWorkers() {
            if (this.stats) {
                this.executor.runningWorkers.increment();
            }
        }

        private void incrementPendingTasks() {
            if (this.stats) {
                this.executor.pendingTasks.increment();
            }
        }

        private void decrementPendingTasks() {
            if (this.stats) {
                this.executor.pendingTasks.decrement();
            }
        }

        boolean executeFromQueue() {
            Runnable polled;
            Runnable runnable2 = polled = this.queue != null ? this.queue.pollFirst() : null;
            if (polled == null) {
                return false;
            }
            try {
                this.decrementPendingTasks();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running: {}", (Object)polled);
                }
                polled.run();
            }
            catch (Exception t2) {
                LOG.warn("Error executing reactive work due to {}. This exception is ignored.", (Object)t2.getMessage(), (Object)t2);
            }
            return true;
        }
    }
}

