/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.cache;

import com.google.common.primitives.Ints;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.kiwiproject.consul.CatalogClient;
import org.kiwiproject.consul.async.ConsulResponseCallback;
import org.kiwiproject.consul.cache.CacheDescriptor;
import org.kiwiproject.consul.cache.ConsulCache;
import org.kiwiproject.consul.config.CacheConfig;
import org.kiwiproject.consul.model.catalog.CatalogService;
import org.kiwiproject.consul.option.Options;
import org.kiwiproject.consul.option.QueryOptions;

public class ServiceCatalogCache
extends ConsulCache<String, CatalogService> {
    private ServiceCatalogCache(CatalogClient catalogClient, String serviceName, QueryOptions queryOptions, int watchSeconds, ConsulCache.Scheduler callbackScheduler) {
        super(CatalogService::getServiceId, (BigInteger index, ConsulResponseCallback<List<V>> callback) -> {
            ServiceCatalogCache.checkWatch(catalogClient.getNetworkTimeoutConfig().getClientReadTimeoutMillis(), watchSeconds);
            catalogClient.getService(serviceName, ServiceCatalogCache.watchParams(index, watchSeconds, queryOptions), callback);
        }, catalogClient.getConfig().getCacheConfig(), catalogClient.getEventHandler(), new CacheDescriptor("catalog.service", serviceName), callbackScheduler);
    }

    public static ServiceCatalogCache newCache(CatalogClient catalogClient, String serviceName, QueryOptions queryOptions, int watchSeconds, ScheduledExecutorService callbackExecutorService) {
        ConsulCache.Scheduler scheduler = ServiceCatalogCache.createExternal(callbackExecutorService);
        return new ServiceCatalogCache(catalogClient, serviceName, queryOptions, watchSeconds, scheduler);
    }

    public static ServiceCatalogCache newCache(CatalogClient catalogClient, String serviceName, QueryOptions queryOptions, int watchSeconds) {
        return new ServiceCatalogCache(catalogClient, serviceName, queryOptions, watchSeconds, ServiceCatalogCache.createDefault());
    }

    public static ServiceCatalogCache newCache(CatalogClient catalogClient, String serviceName) {
        CacheConfig cacheConfig = catalogClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast(cacheConfig.getWatchDuration().getSeconds());
        return ServiceCatalogCache.newCache(catalogClient, serviceName, Options.BLANK_QUERY_OPTIONS, watchSeconds);
    }
}

