/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.util.failover.strategy;

import com.google.common.net.HostAndPort;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.consul.util.failover.strategy.ConsulFailoverStrategy;

public class BlacklistingConsulFailoverStrategy
implements ConsulFailoverStrategy {
    private final Map<HostAndPort, Instant> blacklist = new ConcurrentHashMap<HostAndPort, Instant>();
    private final Collection<HostAndPort> targets;
    private final long timeout;

    public BlacklistingConsulFailoverStrategy(Collection<HostAndPort> targets, long timeout2) {
        this.targets = targets;
        this.timeout = timeout2;
    }

    @Override
    public @NonNull Optional<Request> computeNextStage(@NonNull Request previousRequest, @Nullable Response previousResponse) {
        HostAndPort initialTarget = this.fromRequest(previousRequest);
        if (BlacklistingConsulFailoverStrategy.previousResponseFailedAndWasNot404(previousResponse)) {
            this.blacklist.put(initialTarget, Instant.now());
        }
        if (this.blacklist.containsKey(initialTarget)) {
            Optional<HostAndPort> optionalNext = this.findTargetNotInBlacklist();
            if (optionalNext.isEmpty()) {
                return Optional.empty();
            }
            HostAndPort next = optionalNext.get();
            HttpUrl nextURL = previousRequest.url().newBuilder().host(next.getHost()).port(next.getPort()).build();
            return Optional.of(previousRequest.newBuilder().url(nextURL).build());
        }
        HttpUrl nextURL = previousRequest.url().newBuilder().host(initialTarget.getHost()).port(initialTarget.getPort()).build();
        return Optional.of(previousRequest.newBuilder().url(nextURL).build());
    }

    private Optional<HostAndPort> findTargetNotInBlacklist() {
        return this.targets.stream().filter(target -> {
            if (this.blacklist.containsKey(target)) {
                Instant blacklistedAt = this.blacklist.get(target);
                if (Duration.between(blacklistedAt, Instant.now()).minusMillis(this.timeout).isNegative()) {
                    return false;
                }
                this.blacklist.remove(target);
                return true;
            }
            return true;
        }).findAny();
    }

    private static boolean previousResponseFailedAndWasNot404(Response previousResponse) {
        return Objects.nonNull(previousResponse) && !previousResponse.isSuccessful() && previousResponse.code() != 404;
    }

    @Override
    public boolean isRequestViable(@NonNull Request current) {
        return this.targets.size() > this.blacklist.size() || !this.blacklist.containsKey(this.fromRequest(current));
    }

    @Override
    public void markRequestFailed(@NonNull Request current) {
        this.blacklist.put(this.fromRequest(current), Instant.now());
    }

    private HostAndPort fromRequest(Request request) {
        return HostAndPort.fromParts(request.url().host(), request.url().port());
    }
}

