/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.endpoint.AbstractConsulConsumer;
import org.apache.camel.spi.ExecutorServiceManager;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.EventClient;
import org.kiwiproject.consul.async.EventResponseCallback;
import org.kiwiproject.consul.model.EventResponse;
import org.kiwiproject.consul.model.event.Event;
import org.kiwiproject.consul.option.QueryOptions;
import org.slf4j.LoggerFactory;

public final class ConsulEventConsumer
extends AbstractConsulConsumer<EventClient> {
    private final ExecutorServiceManager executorServiceManager;
    private ScheduledExecutorService scheduledExecutorService;

    public ConsulEventConsumer(ConsulEndpoint endpoint, ConsulConfiguration configuration, Processor processor) {
        super(endpoint, configuration, processor, Consul::eventClient);
        this.executorServiceManager = endpoint.getCamelContext().getExecutorServiceManager();
    }

    @Override
    protected Runnable createWatcher(EventClient client) throws Exception {
        return new EventWatcher(client);
    }

    @Override
    protected void doStart() throws Exception {
        this.scheduledExecutorService = this.executorServiceManager.newSingleThreadScheduledExecutor(this, "ConsulEventConsumer");
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.scheduledExecutorService != null) {
            this.executorServiceManager.shutdownNow(this.scheduledExecutorService);
        }
        super.doStop();
    }

    private class EventWatcher
    extends AbstractConsulConsumer.AbstractWatcher
    implements EventResponseCallback {
        EventWatcher(EventClient client) {
            super(client);
        }

        public void watch(EventClient client) {
            Runnable runnable2 = () -> client.listEvents(ConsulEventConsumer.this.key, QueryOptions.blockSeconds((int)ConsulEventConsumer.this.configuration.getBlockSeconds(), (BigInteger)ConsulEventConsumer.this.index.get()).build(), this);
            ConsulEventConsumer.this.scheduledExecutorService.schedule(runnable2, (long)ConsulEventConsumer.this.configuration.getBlockSeconds().intValue(), TimeUnit.SECONDS);
        }

        @Override
        public void onComplete(EventResponse eventResponse) {
            if (ConsulEventConsumer.this.isRunAllowed()) {
                List<Event> events = this.filterEvents(eventResponse.getEvents(), (BigInteger)ConsulEventConsumer.this.index.get());
                events.forEach(this::onEvent);
                this.setIndex(eventResponse.getIndex());
                this.watch();
            }
        }

        @Override
        public void onFailure(Throwable throwable) {
            this.onError(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onEvent(Event event) {
            LoggerFactory.getLogger(ConsulEventConsumer.this.getClass()).info("{}", (Object)event);
            Exchange exchange = ConsulEventConsumer.this.createExchange(false);
            try {
                Message message = exchange.getIn();
                message.setHeader("CamelConsulKey", ConsulEventConsumer.this.key);
                message.setHeader("CamelConsulResult", true);
                message.setHeader("CamelConsulEventId", event.getId());
                message.setHeader("CamelConsulEventName", event.getName());
                message.setHeader("CamelConsulEventLTime", event.getLTime());
                message.setHeader("CamelConsulVersion", event.getVersion());
                if (event.getNodeFilter().isPresent()) {
                    message.setHeader("CamelConsulNodeFilter", event.getNodeFilter().get());
                }
                if (event.getServiceFilter().isPresent()) {
                    message.setHeader("CamelConsulSessionFilter", event.getServiceFilter().get());
                }
                if (event.getTagFilter().isPresent()) {
                    message.setHeader("CamelConsulTagFilter", event.getTagFilter().get());
                }
                message.setBody(event.getPayload().orElse(null));
                ConsulEventConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                ConsulEventConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
            }
            finally {
                ConsulEventConsumer.this.releaseExchange(exchange, false);
            }
        }

        private List<Event> filterEvents(List<Event> toFilter, BigInteger lastIndex) {
            List<Event> events = toFilter;
            if (lastIndex != null) {
                for (int i = 0; i < events.size(); ++i) {
                    Event event = events.get(i);
                    BigInteger eventIndex = this.getEventIndexFromId(event);
                    if (!eventIndex.equals(lastIndex)) continue;
                    events = events.subList(i + 1, events.size());
                    break;
                }
            }
            return events;
        }

        private BigInteger getEventIndexFromId(Event event) {
            String eventId = event.getId();
            String lower = eventId.substring(0, 8) + eventId.substring(9, 13) + eventId.substring(14, 18);
            String upper = eventId.substring(19, 23) + eventId.substring(24, 36);
            BigInteger lowVal = new BigInteger(lower, 16);
            BigInteger highVal = new BigInteger(upper, 16);
            return lowVal.xor(highVal);
        }
    }
}

