/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import org.apache.camel.Message;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.endpoint.AbstractConsulProducer;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.util.ObjectHelper;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.SessionClient;
import org.kiwiproject.consul.model.session.Session;

public final class ConsulSessionProducer
extends AbstractConsulProducer<SessionClient> {
    public ConsulSessionProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration) {
        super(endpoint, configuration, Consul::sessionClient);
    }

    @InvokeOnHeader(value="CREATE")
    protected void create(Message message) throws Exception {
        this.setBodyAndResult(message, ((SessionClient)this.getClient()).createSession(message.getMandatoryBody(Session.class), message.getHeader("CamelConsulDatacenter", String.class)));
    }

    @InvokeOnHeader(value="DESTROY")
    protected void destroy(Message message) throws Exception {
        String sessionId = message.getHeader("CamelConsulSession", String.class);
        if (ObjectHelper.isEmpty(sessionId)) {
            ((SessionClient)this.getClient()).destroySession(message.getMandatoryBody(String.class), message.getHeader("CamelConsulDatacenter", String.class));
        } else {
            ((SessionClient)this.getClient()).destroySession(sessionId, message.getHeader("CamelConsulDatacenter", String.class));
        }
        this.setBodyAndResult(message, null, true);
    }

    @InvokeOnHeader(value="INFO")
    protected void info(Message message) throws Exception {
        String sessionId = message.getHeader("CamelConsulSession", String.class);
        if (ObjectHelper.isEmpty(sessionId)) {
            this.setBodyAndResult(message, ((SessionClient)this.getClient()).getSessionInfo(message.getMandatoryBody(String.class), message.getHeader("CamelConsulDatacenter", String.class)).orElse(null));
        } else {
            this.setBodyAndResult(message, ((SessionClient)this.getClient()).getSessionInfo(sessionId, message.getHeader("CamelConsulDatacenter", String.class)).orElse(null));
        }
    }

    @InvokeOnHeader(value="LIST")
    protected void list(Message message) throws Exception {
        this.setBodyAndResult(message, ((SessionClient)this.getClient()).listSessions(message.getHeader("CamelConsulDatacenter", String.class)));
    }

    @InvokeOnHeader(value="RENEW")
    protected void renew(Message message) throws Exception {
        String sessionId = message.getHeader("CamelConsulSession", String.class);
        if (ObjectHelper.isEmpty(sessionId)) {
            this.setBodyAndResult(message, ((SessionClient)this.getClient()).renewSession(message.getHeader("CamelConsulDatacenter", String.class), message.getMandatoryBody(String.class)));
        } else {
            this.setBodyAndResult(message, ((SessionClient)this.getClient()).renewSession(message.getHeader("CamelConsulDatacenter", String.class), sessionId));
        }
    }
}

