/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import okhttp3.Headers;
import org.apache.commons.lang3.math.NumberUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kiwiproject.consul.ConsulException;
import org.kiwiproject.consul.async.ConsulResponseCallback;
import org.kiwiproject.consul.model.ConsulResponse;
import org.kiwiproject.consul.monitoring.ClientEventHandler;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Http {
    private final ClientEventHandler eventHandler;

    public Http(ClientEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    private static boolean isSuccessful(Response<?> response, Integer ... okCodes) {
        return response.isSuccessful() || Sets.newHashSet(okCodes).contains(response.code());
    }

    public <T> T extract(Call<T> call, Integer ... okCodes) {
        Response<T> response = this.executeCall(call);
        this.ensureResponseSuccessful(call, response, okCodes);
        return response.body();
    }

    public void handle(Call<Void> call, Integer ... okCodes) {
        Response<Void> response = this.executeCall(call);
        this.ensureResponseSuccessful(call, response, okCodes);
    }

    public <T> ConsulResponse<T> extractConsulResponse(Call<T> call, Integer ... okCodes) {
        Response<T> response = this.executeCall(call);
        this.ensureResponseSuccessful(call, response, okCodes);
        return Http.consulResponse(response);
    }

    private <T> Response<T> executeCall(Call<T> call) {
        try {
            return call.execute();
        }
        catch (IOException e) {
            this.eventHandler.httpRequestFailure(call.request(), e);
            throw new ConsulException(e);
        }
    }

    private <T> void ensureResponseSuccessful(Call<T> call, Response<T> response, Integer ... okCodes) {
        if (!Http.isSuccessful(response, okCodes)) {
            ConsulException exception = new ConsulException(response.code(), response);
            this.eventHandler.httpRequestInvalid(call.request(), exception);
            throw exception;
        }
        this.eventHandler.httpRequestSuccess(call.request());
    }

    public <T> void extractConsulResponse(Call<T> call, ConsulResponseCallback<T> callback, Integer ... okCodes) {
        Callback<T> retrofitCallback = this.createRetrofitCallback(callback, okCodes);
        call.enqueue(retrofitCallback);
    }

    @VisibleForTesting
    <T> Callback<T> createRetrofitCallback(final ConsulResponseCallback<T> callback, final Integer ... okCodes) {
        return new Callback<T>(){

            @Override
            public void onResponse(@NonNull Call<T> call, @NonNull Response<T> response) {
                if (Http.isSuccessful(response, okCodes)) {
                    Http.this.eventHandler.httpRequestSuccess(call.request());
                    callback.onComplete(Http.consulResponse(response));
                } else {
                    ConsulException exception = new ConsulException(response.code(), response);
                    Http.this.eventHandler.httpRequestInvalid(call.request(), exception);
                    callback.onFailure(exception);
                }
            }

            @Override
            public void onFailure(@NonNull Call<T> call, @NonNull Throwable t2) {
                Http.this.eventHandler.httpRequestFailure(call.request(), t2);
                callback.onFailure(t2);
            }
        };
    }

    public <T> void extractBasicResponse(Call<T> call, org.kiwiproject.consul.async.Callback<T> callback, Integer ... okCodes) {
        this.extractConsulResponse(call, this.createConsulResponseCallbackWrapper(callback), okCodes);
    }

    private <T> ConsulResponseCallback<T> createConsulResponseCallbackWrapper(final org.kiwiproject.consul.async.Callback<T> callback) {
        return new ConsulResponseCallback<T>(){

            @Override
            public void onComplete(ConsulResponse<T> consulResponse) {
                callback.onResponse(consulResponse.getResponse());
            }

            @Override
            public void onFailure(Throwable throwable) {
                callback.onFailure(throwable);
            }
        };
    }

    @VisibleForTesting
    static <T> ConsulResponse<T> consulResponse(Response<T> response) {
        Headers headers = response.headers();
        String indexHeaderValue = headers.get("X-Consul-Index");
        String lastContactHeaderValue = headers.get("X-Consul-Lastcontact");
        String knownLeaderHeaderValue = headers.get("X-Consul-Knownleader");
        BigInteger index = Objects.isNull(indexHeaderValue) ? BigInteger.ZERO : new BigInteger(indexHeaderValue);
        long lastContact = Objects.isNull(lastContactHeaderValue) ? 0L : NumberUtils.toLong(lastContactHeaderValue);
        boolean knownLeader = Objects.nonNull(knownLeaderHeaderValue) && Boolean.parseBoolean(knownLeaderHeaderValue);
        return new ConsulResponse<T>(response.body(), lastContact, knownLeader, index, headers.get("X-Cache"), headers.get("Age"));
    }
}

