/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.cluster;

import java.time.Duration;
import org.apache.camel.component.consul.cluster.ConsulClusterConfiguration;
import org.apache.camel.component.consul.cluster.ConsulClusterView;
import org.apache.camel.support.cluster.AbstractCamelClusterService;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;

public final class ConsulClusterService
extends AbstractCamelClusterService<ConsulClusterView> {
    private ConsulClusterConfiguration configuration;

    public ConsulClusterService() {
        this.configuration = new ConsulClusterConfiguration();
    }

    public ConsulClusterService(ConsulClusterConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public ConsulClusterConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConsulClusterConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public String getUrl() {
        return this.configuration.getUrl();
    }

    public void setUrl(String url) {
        this.configuration.setUrl(url);
    }

    public String getDatacenter() {
        return this.configuration.getDatacenter();
    }

    public void setDatacenter(String datacenter) {
        this.configuration.setDatacenter(datacenter);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public String getAclToken() {
        return this.configuration.getAclToken();
    }

    public void setAclToken(String aclToken) {
        this.configuration.setAclToken(aclToken);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public Duration getConnectTimeout() {
        return this.configuration.getConnectTimeout();
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.configuration.setConnectTimeout(connectTimeout);
    }

    public Duration getReadTimeout() {
        return this.configuration.getReadTimeout();
    }

    public void setReadTimeout(Duration readTimeout) {
        this.configuration.setReadTimeout(readTimeout);
    }

    public Duration getWriteTimeout() {
        return this.configuration.getWriteTimeout();
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.configuration.setWriteTimeout(writeTimeout);
    }

    public Integer getBlockSeconds() {
        return this.configuration.getBlockSeconds();
    }

    public void setBlockSeconds(Integer blockSeconds) {
        this.configuration.setBlockSeconds(blockSeconds);
    }

    public int getTtl() {
        return this.configuration.getSessionTtl();
    }

    public void setTtl(int ttl) {
        this.configuration.setSessionTtl(ttl);
    }

    public int getLockDelay() {
        return this.configuration.getSessionLockDelay();
    }

    public void setLockDelay(int lockDelay) {
        this.configuration.setSessionLockDelay(lockDelay);
    }

    public String getRootPath() {
        return this.configuration.getRootPath();
    }

    public void setRootPath(String rootPath) {
        this.configuration.setRootPath(rootPath);
    }

    @Override
    protected ConsulClusterView createView(String namespace) throws Exception {
        ObjectHelper.notNull(this.getCamelContext(), "Camel Context");
        ObjectHelper.notNull(this.getRootPath(), "Consul root path");
        return new ConsulClusterView(this, this.configuration, namespace);
    }
}

