/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.endpoint.AbstractConsulConsumer;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.KeyValueClient;
import org.kiwiproject.consul.async.ConsulResponseCallback;
import org.kiwiproject.consul.model.ConsulResponse;
import org.kiwiproject.consul.model.kv.Value;
import org.kiwiproject.consul.option.QueryOptions;

public final class ConsulKeyValueConsumer
extends AbstractConsulConsumer<KeyValueClient> {
    public ConsulKeyValueConsumer(ConsulEndpoint endpoint, ConsulConfiguration configuration, Processor processor) {
        super(endpoint, configuration, processor, Consul::keyValueClient);
    }

    @Override
    protected Runnable createWatcher(KeyValueClient client) throws Exception {
        return this.configuration.isRecursive() ? new RecursivePathWatcher(client) : new PathWatcher(client);
    }

    private class RecursivePathWatcher
    extends AbstractPathWatcher<List<Value>> {
        RecursivePathWatcher(KeyValueClient client) {
            super(client);
        }

        public void watch(KeyValueClient client) {
            client.getValues(ConsulKeyValueConsumer.this.key, this.queryOptions(), this);
        }

        @Override
        public void onResponse(List<Value> values2) {
            values2.forEach(this::onValue);
        }
    }

    private class PathWatcher
    extends AbstractPathWatcher<Optional<Value>> {
        PathWatcher(KeyValueClient client) {
            super(client);
        }

        public void watch(KeyValueClient client) {
            client.getValue(ConsulKeyValueConsumer.this.key, this.queryOptions(), this);
        }

        @Override
        public void onResponse(Optional<Value> value) {
            value.ifPresent(this::onValue);
        }
    }

    private abstract class AbstractPathWatcher<T>
    extends AbstractConsulConsumer.AbstractWatcher
    implements ConsulResponseCallback<T> {
        protected AbstractPathWatcher(KeyValueClient client) {
            super(client);
        }

        protected QueryOptions queryOptions() {
            return QueryOptions.blockSeconds((int)ConsulKeyValueConsumer.this.configuration.getBlockSeconds(), (BigInteger)ConsulKeyValueConsumer.this.index.get()).build();
        }

        @Override
        public void onComplete(ConsulResponse<T> consulResponse) {
            if (ConsulKeyValueConsumer.this.isRunAllowed()) {
                this.onResponse(consulResponse.getResponse());
                this.setIndex(consulResponse.getIndex());
                this.watch();
            }
        }

        @Override
        public void onFailure(Throwable throwable) {
            this.onError(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onValue(Value value) {
            Exchange exchange = ConsulKeyValueConsumer.this.createExchange(false);
            try {
                Message message = exchange.getIn();
                message.setHeader("CamelConsulKey", value.getKey());
                message.setHeader("CamelConsulResult", true);
                message.setHeader("CamelConsulFlags", value.getFlags());
                message.setHeader("CamelConsulCreateIndex", value.getCreateIndex());
                message.setHeader("CamelConsulLockIndex", value.getLockIndex());
                message.setHeader("CamelConsulModifyIndex", value.getModifyIndex());
                if (value.getSession().isPresent()) {
                    message.setHeader("CamelConsulSession", value.getSession().get());
                }
                message.setBody(ConsulKeyValueConsumer.this.configuration.isValueAsString() ? value.getValueAsString().orElse(null) : value.getValue().orElse(null));
                ConsulKeyValueConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                ConsulKeyValueConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
            }
            finally {
                ConsulKeyValueConsumer.this.releaseExchange(exchange, false);
            }
        }

        protected abstract void onResponse(T var1);
    }
}

