/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import java.util.List;
import org.apache.camel.Message;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.endpoint.AbstractConsulProducer;
import org.apache.camel.spi.InvokeOnHeader;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.KeyValueClient;
import org.kiwiproject.consul.option.PutOptions;
import org.kiwiproject.consul.option.QueryOptions;

public final class ConsulKeyValueProducer
extends AbstractConsulProducer<KeyValueClient> {
    public ConsulKeyValueProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration) {
        super(endpoint, configuration, Consul::keyValueClient);
    }

    @InvokeOnHeader(value="PUT")
    protected void put(Message message) throws Exception {
        message.setHeader("CamelConsulResult", ((KeyValueClient)this.getClient()).putValue(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), message.getBody(String.class), (long)message.getHeader("CamelConsulFlags", 0L, Long.class), message.getHeader("CamelConsulOptions", PutOptions.BLANK, PutOptions.class)));
    }

    @InvokeOnHeader(value="GET_VALUE")
    protected void getValue(Message message) throws Exception {
        boolean asString2 = message.getHeader("CamelConsulValueAsString", this.getConfiguration().isValueAsString(), Boolean.class);
        Object result = asString2 ? ((KeyValueClient)this.getClient()).getValueAsString(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class)).orElse(null) : ((KeyValueClient)this.getClient()).getValue(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), message.getHeader("CamelConsulOptions", QueryOptions.BLANK, QueryOptions.class)).orElse(null);
        this.setBodyAndResult(message, result);
    }

    @InvokeOnHeader(value="GET_VALUES")
    protected void getValues(Message message) throws Exception {
        boolean asString2 = message.getHeader("CamelConsulValueAsString", this.getConfiguration().isValueAsString(), Boolean.class);
        List<Object> result = asString2 ? ((KeyValueClient)this.getClient()).getValuesAsString(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class)) : ((KeyValueClient)this.getClient()).getValues(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), message.getHeader("CamelConsulOptions", QueryOptions.BLANK, QueryOptions.class));
        this.setBodyAndResult(message, result);
    }

    @InvokeOnHeader(value="GET_KEYS")
    protected void getKeys(Message message) throws Exception {
        this.setBodyAndResult(message, ((KeyValueClient)this.getClient()).getKeys(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class)));
    }

    @InvokeOnHeader(value="GET_SESSIONS")
    protected void getSessions(Message message) throws Exception {
        this.setBodyAndResult(message, ((KeyValueClient)this.getClient()).getSession(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class)));
    }

    @InvokeOnHeader(value="DELETE_KEY")
    protected void deleteKey(Message message) throws Exception {
        ((KeyValueClient)this.getClient()).deleteKey(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class));
        message.setHeader("CamelConsulResult", true);
    }

    @InvokeOnHeader(value="DELETE_KEYS")
    protected void deleteKeys(Message message) throws Exception {
        ((KeyValueClient)this.getClient()).deleteKeys(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class));
        message.setHeader("CamelConsulResult", true);
    }

    @InvokeOnHeader(value="LOCK")
    protected void lock(Message message) throws Exception {
        message.setHeader("CamelConsulResult", ((KeyValueClient)this.getClient()).acquireLock(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), message.getBody(String.class), message.getHeader("CamelConsulSession", "", String.class)));
    }

    @InvokeOnHeader(value="UNLOCK")
    protected void unlock(Message message) throws Exception {
        message.setHeader("CamelConsulResult", ((KeyValueClient)this.getClient()).releaseLock(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), this.getMandatoryHeader(message, "CamelConsulSession", String.class)));
    }
}

