/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.time.Duration;
import org.apache.camel.Converter;
import org.apache.camel.util.TimeUtils;

@Converter(generateBulkLoader=true)
public final class DurationConverter {
    private DurationConverter() {
    }

    @Converter(order=1)
    public static Long toMilliSeconds(Duration source2) {
        return source2.toMillis();
    }

    @Converter(order=2)
    public static Duration toDuration(Long source2) {
        return Duration.ofMillis(source2);
    }

    @Converter(order=3)
    public static Duration toDuration(String source2) {
        if (source2.startsWith("P") || source2.startsWith("-P") || source2.startsWith("p") || source2.startsWith("-p")) {
            return Duration.parse(source2);
        }
        return Duration.ofMillis(TimeUtils.toMilliSeconds(source2));
    }

    @Converter(order=4)
    public static String toString(Duration source2) {
        return source2.toString();
    }
}

