/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceHealth;
import org.apache.camel.impl.cloud.DefaultServiceHealth;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@Deprecated(since="4.7")
public class DefaultServiceDefinition
implements ServiceDefinition {
    private static final ServiceHealth DEFAULT_SERVICE_HEALTH = new DefaultServiceHealth();
    private final String id;
    private final String name;
    private final String host;
    private final int port;
    private final Map<String, String> meta;
    private final ServiceHealth health;

    public DefaultServiceDefinition(String name, String host, int port) {
        this(null, name, host, port, Collections.emptyMap(), DEFAULT_SERVICE_HEALTH);
    }

    public DefaultServiceDefinition(String id, String name, String host, int port) {
        this(id, name, host, port, Collections.emptyMap(), DEFAULT_SERVICE_HEALTH);
    }

    public DefaultServiceDefinition(String name, String host, int port, ServiceHealth health) {
        this(null, name, host, port, Collections.emptyMap(), health);
    }

    public DefaultServiceDefinition(String id, String name, String host, int port, ServiceHealth health) {
        this(id, name, host, port, Collections.emptyMap(), health);
    }

    public DefaultServiceDefinition(String name, String host, int port, Map<String, String> meta) {
        this(null, name, host, port, meta, DEFAULT_SERVICE_HEALTH);
    }

    public DefaultServiceDefinition(String id, String name, String host, int port, Map<String, String> meta) {
        this(id, name, host, port, meta, DEFAULT_SERVICE_HEALTH);
    }

    public DefaultServiceDefinition(String name, String host, int port, Map<String, String> meta, ServiceHealth health) {
        this(null, name, host, port, meta, health);
    }

    public DefaultServiceDefinition(String id, String name, String host, int port, Map<String, String> meta, ServiceHealth health) {
        this.id = id;
        this.name = name;
        this.host = host;
        this.port = port;
        this.meta = CollectionHelper.unmodifiableMap(meta);
        this.health = ObjectHelper.supplyIfEmpty(health, () -> DEFAULT_SERVICE_HEALTH);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public ServiceHealth getHealth() {
        return this.health;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.meta;
    }

    public String toString() {
        return "DefaultServiceDefinition[" + this.id + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultServiceDefinition that = (DefaultServiceDefinition)o;
        return this.getPort() == that.getPort() && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getHost(), that.getHost());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getName(), this.getHost(), this.getPort());
    }

    public static Stream<? extends ServiceDefinition> parse(String serverString) {
        return Stream.of(serverString.split(",")).map(part -> {
            String serviceId = null;
            String serviceName = StringHelper.before(part, "@");
            if (serviceName != null) {
                serviceId = StringHelper.before(serviceName, "/");
                if ((serviceName = StringHelper.after(serviceName, "/")) == null) {
                    serviceName = StringHelper.before(part, "@");
                }
                part = StringHelper.after(part, "@");
            }
            String serviceHost = StringHelper.before(part, ":");
            String servicePort = StringHelper.after(part, ":");
            if (ObjectHelper.isNotEmpty(serviceHost) && ObjectHelper.isNotEmpty(servicePort)) {
                return new DefaultServiceDefinition(serviceId, serviceName, serviceHost, Integer.parseInt(servicePort));
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String name;
        private String host;
        private Integer port;
        private Map<String, String> meta;
        private ServiceHealth health;

        public Builder from(ServiceDefinition source2) {
            this.withId(source2.getId());
            this.withName(source2.getName());
            this.withHost(source2.getHost());
            this.withPort(source2.getPort());
            this.withMeta(source2.getMetadata());
            this.withHealth(source2.getHealth());
            return this;
        }

        public Builder from(Map<String, String> properties) {
            ObjectHelper.ifNotEmpty(properties.get("service.id"), this::withId);
            ObjectHelper.ifNotEmpty(properties.get("service.name"), this::withName);
            ObjectHelper.ifNotEmpty(properties.get("service.host"), this::withHost);
            ObjectHelper.ifNotEmpty(properties.get("service.port"), this::withPort);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (!entry.getKey().startsWith("service.")) continue;
                this.addMeta(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public String id() {
            return this.id;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public String name() {
            return this.name;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public String host() {
            return this.host;
        }

        public Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder withPort(String port) {
            if (port != null) {
                this.withPort(Integer.parseInt(port));
            }
            return this;
        }

        public Integer port() {
            return this.port;
        }

        public Builder withMeta(Map<String, String> meta) {
            this.meta = new HashMap<String, String>(meta);
            return this;
        }

        public Builder addMeta(String key, String val) {
            if (this.meta == null) {
                this.meta = new HashMap<String, String>();
            }
            this.meta.put(key, val);
            return this;
        }

        public Builder addAllMeta(Map<String, String> meta) {
            if (this.meta == null) {
                this.meta = new HashMap<String, String>();
            }
            this.meta.putAll(meta);
            return this;
        }

        public Map<String, String> meta() {
            return this.meta;
        }

        public Builder withHealth(ServiceHealth health) {
            this.health = health;
            return this;
        }

        public ServiceHealth health() {
            return this.health;
        }

        public ServiceDefinition build() {
            return new DefaultServiceDefinition(this.id, this.name, this.host, this.port != null ? this.port : -1, this.meta, this.health);
        }
    }
}

