/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Processor;
import org.apache.camel.builder.AggregationStrategyClause;
import org.apache.camel.builder.ProcessClause;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="multicast")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MulticastDefinition
extends OutputDefinition<MulticastDefinition>
implements ExecutorServiceAwareDefinition<MulticastDefinition> {
    @XmlTransient
    private ExecutorService executorServiceBean;
    @XmlTransient
    private AggregationStrategy aggregationStrategyBean;
    @XmlTransient
    private Processor onPrepareProcessor;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.AggregationStrategy")
    private String aggregationStrategy;
    @XmlAttribute
    @Metadata(label="advanced")
    private String aggregationStrategyMethodName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String aggregationStrategyMethodAllowNull;
    @Deprecated(since="4.7.0")
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String parallelAggregate;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String parallelProcessing;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String synchronous;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String streaming;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String stopOnException;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.time.Duration", defaultValue="0")
    private String timeout;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ExecutorService")
    private String executorService;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.Processor")
    private String onPrepare;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String shareUnitOfWork;

    public MulticastDefinition() {
    }

    protected MulticastDefinition(MulticastDefinition source2) {
        super(source2);
        this.executorServiceBean = source2.executorServiceBean;
        this.aggregationStrategyBean = source2.aggregationStrategyBean;
        this.onPrepareProcessor = source2.onPrepareProcessor;
        this.aggregationStrategy = source2.aggregationStrategy;
        this.aggregationStrategyMethodName = source2.aggregationStrategyMethodName;
        this.aggregationStrategyMethodAllowNull = source2.aggregationStrategyMethodAllowNull;
        this.parallelAggregate = source2.parallelAggregate;
        this.parallelProcessing = source2.parallelProcessing;
        this.synchronous = source2.synchronous;
        this.streaming = source2.streaming;
        this.stopOnException = source2.stopOnException;
        this.timeout = source2.timeout;
        this.executorService = source2.executorService;
        this.onPrepare = source2.onPrepare;
        this.shareUnitOfWork = source2.shareUnitOfWork;
    }

    @Override
    public MulticastDefinition copyDefinition() {
        return new MulticastDefinition(this);
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    @Override
    public String toString() {
        return "Multicast[" + String.valueOf(this.getOutputs()) + "]";
    }

    @Override
    public String getShortName() {
        return "multicast";
    }

    @Override
    public String getLabel() {
        return "multicast";
    }

    public AggregationStrategyClause<MulticastDefinition> aggregationStrategy() {
        AggregationStrategyClause<MulticastDefinition> clause = new AggregationStrategyClause<MulticastDefinition>(this);
        this.setAggregationStrategy(clause);
        return clause;
    }

    public MulticastDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public MulticastDefinition aggregationStrategy(String aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public MulticastDefinition aggregationStrategyMethodName(String methodName) {
        this.setAggregationStrategyMethodName(methodName);
        return this;
    }

    public MulticastDefinition aggregationStrategyMethodAllowNull() {
        this.setAggregationStrategyMethodAllowNull(Boolean.toString(true));
        return this;
    }

    public MulticastDefinition parallelProcessing() {
        this.setParallelProcessing(Boolean.toString(true));
        return this;
    }

    public MulticastDefinition parallelProcessing(String parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    public MulticastDefinition parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(Boolean.toString(parallelProcessing));
        return this;
    }

    public MulticastDefinition synchronous() {
        return this.synchronous(true);
    }

    public MulticastDefinition synchronous(boolean synchronous) {
        return this.synchronous(Boolean.toString(synchronous));
    }

    public MulticastDefinition synchronous(String synchronous) {
        this.setSynchronous(synchronous);
        return this;
    }

    @Deprecated(since="4.7.0")
    public MulticastDefinition parallelAggregate() {
        this.setParallelAggregate(Boolean.toString(true));
        return this;
    }

    @Deprecated(since="4.7.0")
    public MulticastDefinition parallelAggregate(boolean parallelAggregate) {
        this.setParallelAggregate(Boolean.toString(parallelAggregate));
        return this;
    }

    @Deprecated(since="4.7.0")
    public MulticastDefinition parallelAggregate(String parallelAggregate) {
        this.setParallelAggregate(parallelAggregate);
        return this;
    }

    public MulticastDefinition streaming() {
        this.setStreaming(Boolean.toString(true));
        return this;
    }

    public MulticastDefinition stopOnException() {
        return this.stopOnException(Boolean.toString(true));
    }

    public MulticastDefinition stopOnException(String stopOnException) {
        this.setStopOnException(stopOnException);
        return this;
    }

    @Override
    public MulticastDefinition executorService(ExecutorService executorService) {
        this.executorServiceBean = executorService;
        return this;
    }

    @Override
    public MulticastDefinition executorService(String executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public ProcessClause<MulticastDefinition> onPrepare() {
        ProcessClause<MulticastDefinition> clause;
        this.onPrepareProcessor = clause = new ProcessClause<MulticastDefinition>(this);
        return clause;
    }

    public MulticastDefinition onPrepare(Processor onPrepare) {
        this.onPrepareProcessor = onPrepare;
        return this;
    }

    public MulticastDefinition onPrepare(String onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public MulticastDefinition timeout(long timeout2) {
        return this.timeout(Long.toString(timeout2));
    }

    public MulticastDefinition timeout(String timeout2) {
        this.setTimeout(timeout2);
        return this;
    }

    public MulticastDefinition shareUnitOfWork() {
        this.setShareUnitOfWork(Boolean.toString(true));
        return this;
    }

    public AggregationStrategy getAggregationStrategyBean() {
        return this.aggregationStrategyBean;
    }

    public Processor getOnPrepareProcessor() {
        return this.onPrepareProcessor;
    }

    @Override
    public ExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorService;
    }

    public String getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(String parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(String synchronous) {
        this.synchronous = synchronous;
    }

    public String getStreaming() {
        return this.streaming;
    }

    public void setStreaming(String streaming) {
        this.streaming = streaming;
    }

    public String getStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(String stopOnException) {
        this.stopOnException = stopOnException;
    }

    public String getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(String aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategyBean = aggregationStrategy;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    public String getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(String aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.executorService = executorService;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    public String getShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(String shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    @Deprecated(since="4.7.0")
    public String getParallelAggregate() {
        return this.parallelAggregate;
    }

    @Deprecated(since="4.7.0")
    public void setParallelAggregate(String parallelAggregate) {
        this.parallelAggregate = parallelAggregate;
    }

    public String getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(String onPrepare) {
        this.onPrepare = onPrepare;
    }
}

