/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.NodeIdFactory;

@XmlType(name="optionalIdentifiedDefinition")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class OptionalIdentifiedDefinition<T extends OptionalIdentifiedDefinition<T>>
implements NamedNode,
IdAware,
CamelContextAware {
    private CamelContext camelContext;
    private String id;
    private Boolean customId;
    private String description;
    private int lineNumber = -1;
    private String location;

    protected OptionalIdentifiedDefinition() {
    }

    protected OptionalIdentifiedDefinition(OptionalIdentifiedDefinition<?> source2) {
        this.camelContext = source2.camelContext;
        this.id = source2.id;
        this.customId = source2.customId;
        this.description = source2.description;
        this.lineNumber = source2.lineNumber;
        this.location = source2.location;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    @XmlTransient
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNodePrefixId() {
        RouteDefinition route;
        boolean allowPrefix;
        String prefix = null;
        boolean iAmRoute = this instanceof RouteDefinition;
        boolean bl = allowPrefix = !iAmRoute && this instanceof ProcessorDefinition;
        if (allowPrefix && (route = ProcessorDefinitionHelper.getRoute(this)) != null) {
            prefix = route.getNodePrefixId();
        }
        return prefix;
    }

    @Override
    @XmlAttribute
    @Metadata(description="The id of this node")
    public void setId(String id) {
        this.id = id;
        this.customId = id != null ? Boolean.valueOf(true) : null;
    }

    @Override
    public void setGeneratedId(String id) {
        this.id = id;
        this.customId = null;
    }

    public String getDescription() {
        return this.description;
    }

    @XmlAttribute
    @Metadata(description="The description for this node")
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public NamedNode getParent() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    @XmlTransient
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    @XmlTransient
    public void setLocation(String location) {
        this.location = location;
    }

    public T description(String description) {
        this.description = description;
        return (T)this;
    }

    public T id(String id) {
        this.setId(id);
        return (T)this;
    }

    public String idOrCreate(NodeIdFactory factory2) {
        String prefix;
        boolean iAmRoute;
        boolean allowPrefix;
        if (this.id == null) {
            this.setGeneratedId(factory2.createId(this));
        }
        boolean bl = allowPrefix = !(iAmRoute = this instanceof RouteDefinition) && this instanceof ProcessorDefinition;
        if (allowPrefix && (prefix = this.getNodePrefixId()) != null) {
            return prefix + this.id;
        }
        return this.id;
    }

    public Boolean getCustomId() {
        return this.customId;
    }

    @XmlAttribute
    public void setCustomId(Boolean customId) {
        this.customId = customId;
    }

    public boolean hasCustomIdAssigned() {
        return this.customId != null && this.customId != false;
    }

    @Override
    public String getDescriptionText() {
        return this.description;
    }
}

