/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.cloud.ServiceLoadBalancerFactory;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.cloud.ServiceCallConfiguration;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="routing,cloud,load-balancing")
@XmlRootElement(name="loadBalancerConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Configurer
@Deprecated(since="3.19.0")
public class ServiceCallServiceLoadBalancerConfiguration
extends ServiceCallConfiguration
implements ServiceLoadBalancerFactory {
    @XmlTransient
    private final ServiceCallDefinition parent;
    @XmlTransient
    private final String factoryKey;

    public ServiceCallServiceLoadBalancerConfiguration() {
        this(null, null);
    }

    public ServiceCallServiceLoadBalancerConfiguration(ServiceCallDefinition parent, String factoryKey) {
        this.parent = parent;
        this.factoryKey = factoryKey;
    }

    public ServiceCallDefinition end() {
        return this.parent;
    }

    public ProcessorDefinition<?> endParent() {
        return this.parent.end();
    }

    @Override
    public ServiceCallServiceLoadBalancerConfiguration property(String key, String value) {
        return (ServiceCallServiceLoadBalancerConfiguration)super.property(key, value);
    }

    @Override
    public ServiceLoadBalancer newInstance(CamelContext camelContext) throws Exception {
        ServiceLoadBalancer answer;
        ObjectHelper.notNull(this.factoryKey, "LoadBalancer factoryKey");
        ServiceLoadBalancerFactory factory2 = CamelContextHelper.lookup(camelContext, this.factoryKey, ServiceLoadBalancerFactory.class);
        if (factory2 != null) {
            answer = (ServiceLoadBalancer)factory2.newInstance(camelContext);
        } else {
            Class<?> type;
            try {
                type = camelContext.getCamelContextExtension().getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(this.factoryKey).orElseThrow();
            }
            catch (Exception e) {
                throw new NoFactoryAvailableException("META-INF/services/org/apache/camel/cloud/" + this.factoryKey, e);
            }
            if (!ServiceLoadBalancerFactory.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException("Resolving LoadBalancer: " + this.factoryKey + " detected type conflict: Not a LoadBalancerFactory implementation. Found: " + type.getName());
            }
            factory2 = (ServiceLoadBalancerFactory)camelContext.getInjector().newInstance(type, false);
            try {
                Map<String, Object> parameters = this.getConfiguredOptions(camelContext, this);
                parameters.replaceAll((k, v) -> {
                    if (v instanceof String) {
                        String str = (String)v;
                        try {
                            v = camelContext.resolvePropertyPlaceholders(str);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Exception while resolving %s (%s)", k, v), e);
                        }
                    }
                    return v;
                });
                Map<String, String> map = this.getPropertiesAsMap(camelContext);
                if (map != null && !map.isEmpty()) {
                    parameters.put("properties", map);
                }
                this.postProcessFactoryParameters(camelContext, parameters);
                PropertyBindingSupport.build().bind(camelContext, factory2, parameters);
                answer = (ServiceLoadBalancer)factory2.newInstance(camelContext);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return answer;
    }
}

