/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.1.0", label="dataformat,transformation,csv", title="Flatpack")
@XmlRootElement(name="flatpack")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlatpackDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String definition;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String fixed;
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String delimiter;
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String ignoreFirstRecord;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowShortLines;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreExtraColumns;
    @XmlAttribute
    @Metadata(label="advanced")
    private String textQualifier;
    @XmlAttribute
    @Metadata(label="advanced")
    private String parserFactoryRef;

    public FlatpackDataFormat() {
        super("flatpack");
    }

    protected FlatpackDataFormat(FlatpackDataFormat source2) {
        super(source2);
        this.definition = source2.definition;
        this.fixed = source2.fixed;
        this.delimiter = source2.delimiter;
        this.ignoreFirstRecord = source2.ignoreFirstRecord;
        this.allowShortLines = source2.allowShortLines;
        this.ignoreExtraColumns = source2.ignoreExtraColumns;
        this.textQualifier = source2.textQualifier;
        this.parserFactoryRef = source2.parserFactoryRef;
    }

    private FlatpackDataFormat(Builder builder) {
        this();
        this.definition = builder.definition;
        this.fixed = builder.fixed;
        this.delimiter = builder.delimiter;
        this.ignoreFirstRecord = builder.ignoreFirstRecord;
        this.allowShortLines = builder.allowShortLines;
        this.ignoreExtraColumns = builder.ignoreExtraColumns;
        this.textQualifier = builder.textQualifier;
        this.parserFactoryRef = builder.parserFactoryRef;
    }

    @Override
    public FlatpackDataFormat copyDefinition() {
        return new FlatpackDataFormat(this);
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getFixed() {
        return this.fixed;
    }

    public void setFixed(String fixed) {
        this.fixed = fixed;
    }

    public String getIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(String ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public String getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(String textQualifier) {
        this.textQualifier = textQualifier;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getAllowShortLines() {
        return this.allowShortLines;
    }

    public void setAllowShortLines(String allowShortLines) {
        this.allowShortLines = allowShortLines;
    }

    public String getIgnoreExtraColumns() {
        return this.ignoreExtraColumns;
    }

    public void setIgnoreExtraColumns(String ignoreExtraColumns) {
        this.ignoreExtraColumns = ignoreExtraColumns;
    }

    public String getParserFactoryRef() {
        return this.parserFactoryRef;
    }

    public void setParserFactoryRef(String parserFactoryRef) {
        this.parserFactoryRef = parserFactoryRef;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<FlatpackDataFormat> {
        private String definition;
        private String fixed;
        private String delimiter;
        private String ignoreFirstRecord;
        private String allowShortLines;
        private String ignoreExtraColumns;
        private String textQualifier;
        private String parserFactoryRef;

        public Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public Builder fixed(String fixed) {
            this.fixed = fixed;
            return this;
        }

        public Builder fixed(boolean fixed) {
            this.fixed = Boolean.toString(fixed);
            return this;
        }

        public Builder ignoreFirstRecord(String ignoreFirstRecord) {
            this.ignoreFirstRecord = ignoreFirstRecord;
            return this;
        }

        public Builder ignoreFirstRecord(boolean ignoreFirstRecord) {
            this.ignoreFirstRecord = Boolean.toString(ignoreFirstRecord);
            return this;
        }

        public Builder textQualifier(String textQualifier) {
            this.textQualifier = textQualifier;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder allowShortLines(String allowShortLines) {
            this.allowShortLines = allowShortLines;
            return this;
        }

        public Builder allowShortLines(boolean allowShortLines) {
            this.allowShortLines = Boolean.toString(allowShortLines);
            return this;
        }

        public Builder ignoreExtraColumns(String ignoreExtraColumns) {
            this.ignoreExtraColumns = ignoreExtraColumns;
            return this;
        }

        public Builder ignoreExtraColumns(boolean ignoreExtraColumns) {
            this.ignoreExtraColumns = Boolean.toString(ignoreExtraColumns);
            return this;
        }

        public Builder parserFactoryRef(String parserFactoryRef) {
            this.parserFactoryRef = parserFactoryRef;
            return this;
        }

        @Override
        public FlatpackDataFormat end() {
            return new FlatpackDataFormat(this);
        }
    }
}

