/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Expression;
import org.apache.camel.processor.aggregate.AggregationStrategyMethodInfo;
import org.apache.camel.processor.aggregate.AggregationStrategyParameterInfo;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationStrategyBeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationStrategyBeanInfo.class);
    private final Class<?> type;
    private final Method method;

    public AggregationStrategyBeanInfo(Class<?> type, Method method) {
        this.type = type;
        this.method = method;
    }

    protected AggregationStrategyMethodInfo createMethodInfo() {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        int size = parameterTypes.length;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating MethodInfo for class: {} method: {} having {} parameters", new Object[]{this.type, this.method, size});
        }
        if (size < 2) {
            throw new IllegalArgumentException("The method " + this.method.getName() + " must have at least two parameters, has: " + size);
        }
        if (size % 2 != 0) {
            throw new IllegalArgumentException("The method " + this.method.getName() + " must have equal number of parameters, has: " + size);
        }
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            if (annotations.length <= 0) continue;
            throw new IllegalArgumentException("Method parameter annotation: " + annotations[0] + " at index: " + i + " is not supported on method: " + this.method);
        }
        ArrayList<AggregationStrategyParameterInfo> oldParameters = new ArrayList<AggregationStrategyParameterInfo>();
        for (int i = 0; i < size / 2; ++i) {
            AggregationStrategyBeanInfo.addParameters(parameterTypes, i, oldParameters);
        }
        ArrayList<AggregationStrategyParameterInfo> newParameters = new ArrayList<AggregationStrategyParameterInfo>();
        for (int i = size / 2; i < size; ++i) {
            AggregationStrategyBeanInfo.addParameters(parameterTypes, i, newParameters);
        }
        return new AggregationStrategyMethodInfo(this.method, oldParameters, newParameters);
    }

    private static void addParameters(Class<?>[] parameterTypes, int i, List<AggregationStrategyParameterInfo> parameters) {
        Class<?> parameterType = parameterTypes[i];
        if (parameters.isEmpty()) {
            Expression body = ExpressionBuilder.mandatoryBodyExpression(parameterType);
            AggregationStrategyParameterInfo info = new AggregationStrategyParameterInfo(i, parameterType, body);
            parameters.add(info);
        } else if (parameters.size() == 1) {
            Expression headersExpression = ExpressionBuilder.headersExpression();
            AggregationStrategyParameterInfo info = new AggregationStrategyParameterInfo(i, parameterType, headersExpression);
            parameters.add(info);
        } else if (parameters.size() == 2) {
            Expression properties = ExpressionBuilder.exchangePropertiesExpression();
            AggregationStrategyParameterInfo info = new AggregationStrategyParameterInfo(i, parameterType, properties);
            parameters.add(info);
        }
    }
}

